package com.biz.crm.tpm.business.account.reconciliation.rule.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleDateConfigEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.mapper.TpmAccountReconciliationRuleDateConfigMapper;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @ClassName TpmAccountReconciliationRuleDateConfigRepository
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/7
 */
@Component
public class TpmAccountReconciliationRuleDateConfigRepository extends ServiceImpl<TpmAccountReconciliationRuleDateConfigMapper, TpmAccountReconciliationRuleDateConfigEntity> {

    public List<TpmAccountReconciliationRuleDateConfigRespVo> findByRuleCode(String code) {
        if (StringUtil.isEmpty(code)) {
            return Collections.emptyList();
        }
        List<String> codeList = new ArrayList<>();
        codeList.add(code);
        return this.findByRuleCodes(codeList);
    }

    public List<TpmAccountReconciliationRuleDateConfigRespVo> findByRuleCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findByRuleCodes(codeList, TenantUtils.getTenantCode());
    }
}
