package com.biz.crm.tpm.business.account.reconciliation.rule.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleRFactorEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.mapper.TpmAccountReconciliationRuleRFactorMapper;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @ClassName TpmAccountReconciliationRuleRFactoryRepository
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/7
 */
@Component
public class TpmAccountReconciliationRuleRFactorRepository extends ServiceImpl<TpmAccountReconciliationRuleRFactorMapper, TpmAccountReconciliationRuleRFactorEntity> {


    public List<TpmAccountReconciliationRuleRFactorRespVo> findByRuleCode(String code) {
        if (StringUtil.isEmpty(code)) {
            return Collections.emptyList();
        }
        List<String> codeList = new ArrayList<>();
        codeList.add(code);
        return this.findByRuleCodes(codeList);
    }

    public List<TpmAccountReconciliationRuleRFactorRespVo> findByRuleCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findByRuleCodes(codeList, TenantUtils.getTenantCode());
    }
}
