package com.biz.crm.tpm.business.account.reconciliation.rule.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.mapper.TpmAccountReconciliationRuleMapper;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @ClassName TpmAccountReconciliationRuleRepository
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/7
 */
@Component
public class TpmAccountReconciliationRuleRepository extends ServiceImpl<TpmAccountReconciliationRuleMapper, TpmAccountReconciliationRuleEntity> {


    /**
     * 获取当前优先的 对账单生成规则
     *
     * @param pageRequest
     * @return
     */
    public Page<TpmAccountReconciliationRuleRespVo> findCurrentEffectiveRule(Pageable pageRequest) {
        Page<TpmAccountReconciliationRuleRespVo> page = new Page<>(pageRequest.getPageNumber(), pageRequest.getPageSize());
        return this.baseMapper.findCurrentEffectiveRule(page, TenantUtils.getTenantCode());
    }


}
