package com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.util.List;

/**
 * @ClassName TpmAccountReconciliationRuleDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/7
 */
@Data
@ApiModel("对账规则数据传输类")
public class TpmAccountReconciliationRuleDto extends TenantFlagOpDto {

    /**
     * 对账规则编码
     */
    @ApiModelProperty(value = "对账规则编码", notes = "")
    private String accountReconciliationRuleCode;
    /**
     * 对账规则名称
     */
    @ApiModelProperty(value = "对账规则名称", notes = "")
    private String accountReconciliationRuleName;
    /**
     * 对账类型
     */
    @ApiModelProperty(value = "对账类型[account_reconciliation_type]", notes = "")
    private String accountReconciliationType;
    /**
     * 有效开始时间
     */
    @ApiModelProperty(value = "有效开始时间", notes = "")
    private String startDate;
    /**
     * 有效结束时间
     */
    @ApiModelProperty(value = "有效结束时间", notes = "")
    private String endDate;
    /**
     * 生成周期
     */
    @ApiModelProperty(value = "生成周期", notes = "")
    private String generatePeriod;
    /**
     * 生成时间
     */
    @ApiModelProperty(value = "生成时间", notes = "")
    private Integer generateCostDay;
    /**
     * 业态编码
     */
    @ApiModelProperty(value = "业态编码", notes = "")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "")
    private String businessUnitCode;

    @ApiModelProperty(value = "对账生成时间配置")
    private List<TpmAccountReconciliationRuleDateConfigDto> dateConfigList;

    @ApiModelProperty("对账要素列表")
    private List<TpmAccountReconciliationRuleRFactorDto> factorList;

    public boolean validate(){
        Validate.isTrue(StringUtils.isNotEmpty(this.accountReconciliationRuleName), "对账规则名称不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.startDate), "开始日期不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.endDate), "结束日期不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.generatePeriod), "生成周期不能为空");
        Validate.isTrue(this.generateCostDay != null, "生成时间不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.businessFormatCode), "业态不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.businessUnitCode), "业务单元不能为空");
        Validate.isTrue(CollectionUtils.isNotEmpty(dateConfigList), "对账生成时间配置不能为空");
        Validate.isTrue(CollectionUtils.isNotEmpty(factorList), "对账要素列表不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.accountReconciliationType), "对账类型不能为空");
        return true;
    }
}
