package com.biz.crm.tpm.business.account.reconciliation.rule.sdk.event;

import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @ClassName TpmAccountReconciliationRuleLogEventListener
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/12
 */
public interface TpmAccountReconciliationRuleLogEventListener extends NebulaEvent {

    /**
     * 当业务单元创建时触发
     *
     * @param dto
     */
    default void onCreate(TpmAccountReconciliationRuleLogDto dto) {
    }

    /**
     * 当业务单元修改时触发
     *
     * @param dto
     */
    default void onUpdate(TpmAccountReconciliationRuleLogDto dto) {
    }

    /**
     * 当业务单元禁用时触发
     *
     * @param dto
     */
    default void onDisable(TpmAccountReconciliationRuleLogDto dto) {
    }

    /**
     * 当业务单元启用时触发
     *
     * @param dto
     */
    default void onEnable(TpmAccountReconciliationRuleLogDto dto) {
    }

    /**
     * 当业务单元删除时触发
     *
     * @param dto
     */
    default void onDelete(TpmAccountReconciliationRuleLogDto dto) {
    }
    
}
