package com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDateConfigDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo;
import org.springframework.data.domain.Pageable;

/**
 * (TpmAccountReconciliationRuleDto)表服务接口
 *
 * @author jiangyin
 * @since 2022-11-07 17:44:49
 */
public interface TpmAccountReconciliationRuleDateConfigService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TpmAccountReconciliationRuleDateConfigRespVo queryById(String id);

    /**
     * 分页查询
     *
     * @param reqVo 筛选条件
     * @param pageable 分页对象
     * @return 查询结果
     */
    Page<TpmAccountReconciliationRuleDateConfigRespVo> queryByPage(TpmAccountReconciliationRuleDateConfigDto reqVo, Pageable pageable);

    /**
     * 新增数据
     *
     * @param reqVo 实例对象
     * @return 实例对象
     */
    TpmAccountReconciliationRuleDateConfigRespVo create(TpmAccountReconciliationRuleDateConfigDto reqVo);

    /**
     * 修改数据
     *
     * @param reqVo 实例对象
     * @return 实例对象
     */
    TpmAccountReconciliationRuleDateConfigRespVo edit(TpmAccountReconciliationRuleDateConfigDto reqVo);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(String id);

}
