package com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service;

import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleRFactorDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * (TpmAccountReconciliationRuleRFactory)表服务接口
 *
 * @author jiangyin
 * @since 2022-11-07 17:44:19
 */
public interface TpmAccountReconciliationRuleRFactorService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TpmAccountReconciliationRuleRFactorRespVo queryById(String id);

    /**
     * 分页查询
     *
     * @param reqVo 筛选条件
     * @param pageRequest      分页对象
     * @return 查询结果
     */
    Page<TpmAccountReconciliationRuleRFactorRespVo> queryByPage(TpmAccountReconciliationRuleRFactorDto reqVo, Pageable pageRequest);

    /**
     * 新增数据
     *
     * @param reqVo 实例对象
     * @return 实例对象
     */
    TpmAccountReconciliationRuleRFactorRespVo create(TpmAccountReconciliationRuleRFactorDto reqVo);

    /**
     * 修改数据
     *
     * @param reqVo 实例对象
     * @return 实例对象
     */
    TpmAccountReconciliationRuleRFactorRespVo edit(TpmAccountReconciliationRuleRFactorDto reqVo);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(String id);

}
