package com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * (TpmAccountReconciliationRule)表服务接口
 *
 * @author jiangyin
 * @since 2022-11-07 17:37:58
 */
public interface TpmAccountReconciliationRuleService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TpmAccountReconciliationRuleRespVo queryById(String id);

    /**
     * 分页查询
     *
     * @param TpmAccountReconciliationRuleRespVo 筛选条件
     * @param pageRequest                  分页对象
     * @return 查询结果
     */
    Page<TpmAccountReconciliationRuleRespVo> queryByPage(TpmAccountReconciliationRuleDto TpmAccountReconciliationRuleRespVo, Pageable pageRequest);

    /**
     * 新增数据
     *
     * @param TpmAccountReconciliationRuleRespVo 实例对象
     * @return 实例对象
     */
    TpmAccountReconciliationRuleDto create(TpmAccountReconciliationRuleDto TpmAccountReconciliationRuleRespVo);

    /**
     * 修改数据
     *
     * @param TpmAccountReconciliationRuleRespVo 实例对象
     * @return 实例对象
     */
    TpmAccountReconciliationRuleDto edit(TpmAccountReconciliationRuleDto TpmAccountReconciliationRuleRespVo);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(String id);

    /**
     * 通过主键列表删除数据
     * @param ids 主键列表
     * @author jiangyin
     * @date 2022/11/9 15:51
     * @return void
     */
    void deleteByIdList(List<String> ids);

    /**
     * 通过主键列表启用数据
     * @param ids 主键列表
     * @author jiangyin
     * @date 2022/11/9 15:51
     * @return void
     */
    void enable(List<String> ids);

    /**
     * 通过主键列表禁用数据
     * @param ids 主键列表
     * @author jiangyin
     * @date 2022/11/9 15:51
     * @return void
     */
    void disable(List<String> ids);

    /**
     * 获取当前时间有效的对账规则
     * @param
     * @param pageRequest
     * @author jiangyin
     * @date 2022/11/25 14:24
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo>>
     */
    Page<TpmAccountReconciliationRuleRespVo> findCurrentEffectiveRule(Pageable pageRequest);

    TpmAccountReconciliationRuleRespVo findByCode(String code);
}
