package com.biz.crm.tpm.business.account.subject.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.subject.feign.feign.internal.AccountSubjectFeignImpl;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import io.swagger.annotations.ApiParam;
import org.apache.ibatis.annotations.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author huojia
 * @date 2022年12月13日 9:58
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = AccountSubjectFeignImpl.class)
public interface AccountSubjectFeign {

    /**
     * 查询所有会计科目
     *
     * @param accountSubjectDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo>>
     * @author huojia
     * @date 2022/12/13 10:04
     **/
    @GetMapping("/v1/account/subject/findAllList")
    Result<List<AccountSubjectVo>> findAllList(@RequestBody AccountSubjectSelectDto accountSubjectDto);

    /**
     * 分页查询会计科目
     *
     * @param pageable
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo>>
     * @author huojia
     * @date 2022/12/13 10:07
     **/
    @GetMapping("/v1/account/subject/findByConditions")
    Result<Page<AccountSubjectVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                    @ApiParam(name = "accountSubjectDto", value = "会计科目信息") AccountSubjectDto dto);
    /**
     * 根据编码查询会计科目信息
     * @param codes 编码
     * @return Result
     */
    @GetMapping("/v1/account/subject/findAccountSubjectByCodes")
    Result<List<AccountSubjectVo>> findAccountSubjectByCodes(@RequestParam("codes") List<String> codes);

    @PostMapping("/v1/account/subject/findListByCode")
    Result<List<AccountSubjectVo>> findListByCode(@RequestBody List<String> codes);
}