package com.biz.crm.tpm.business.account.subject.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.subject.feign.feign.AccountSubjectFeign;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author huojia
 * @date 2022年12月13日 9:59
 */
@Slf4j
@Component
public class AccountSubjectFeignImpl implements FallbackFactory<AccountSubjectFeign> {

    @Override
    public AccountSubjectFeign create(Throwable throwable) {
        log.error("进入AccountSubjectFeign熔断", throwable);
        return new AccountSubjectFeign() {

            @Override
            public Result<List<AccountSubjectVo>> findAllList(AccountSubjectSelectDto accountSubjectDto) {
                throw new UnsupportedOperationException("批量查询会计科目熔断");
            }

            @Override
            public Result<Page<AccountSubjectVo>> findByConditions(Pageable pageable, AccountSubjectDto dto) {
                throw new UnsupportedOperationException("分页查询会计科目熔断");
            }

            @Override
            public Result<List<AccountSubjectVo>> findListByCode(List<String> codes) {
                throw new UnsupportedOperationException("会计科目熔断");
            }

            @Override
            public Result<List<AccountSubjectVo>> findAccountSubjectByCodes(List<String> codes) {

                throw new UnsupportedOperationException("根据编码查询会计科目熔断");

            }
        };
    }
}
