package com.biz.crm.tpm.business.account.subject.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.subject.feign.feign.AccountSubjectFeign;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author huojia
 * @date 2022年12月13日 9:57
 */
@Slf4j
@Service
public class AccountSubjectServiceImpl implements AccountSubjectService {

    @Resource
    private AccountSubjectFeign accountSubjectFeign;

    @Override
    public Page<AccountSubjectVo> findByConditions(Pageable pageable, AccountSubjectDto dto) {
        Result<Page<AccountSubjectVo>> result = accountSubjectFeign.findByConditions(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<AccountSubjectVo> findAllList(AccountSubjectSelectDto accountSubjectDto) {
        Result<List<AccountSubjectVo>> result = accountSubjectFeign.findAllList(accountSubjectDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<AccountSubjectVo> findListByCode(List<String> codeList) {
        Result<List<AccountSubjectVo>> result = accountSubjectFeign.findListByCode(codeList);
        return result.getResult();
    }

    @Override
    public void pullAccountSubjectList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AccountSubjectVo> findAccountSubjectByCode(List<String> codes) {

        Result<List<AccountSubjectVo>> resultAccountSubject = accountSubjectFeign.findAccountSubjectByCodes(codes);

        Assert.isTrue(resultAccountSubject.isSuccess(), resultAccountSubject.getMessage());

        return resultAccountSubject.getResult();

    }
}
