package com.biz.crm.tpm.business.account.subject.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 16:41
 */
@RestController
@RequestMapping("/v1/account/subject")
@Slf4j
@Api(tags = "会计科目")
public class AccountSubjectController {

    @Resource
    private AccountSubjectService accountSubjectService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<AccountSubjectVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                           @ApiParam(name = "accountSubjectDto", value = "会计科目信息") AccountSubjectDto dto) {
        try {
            Page<AccountSubjectVo> page = this.accountSubjectService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "会计科目下拉框")
    @PostMapping("findAllList")
    public Result<List<AccountSubjectVo>> findAllList(@RequestBody AccountSubjectSelectDto accountSubjectDto) {
        try {
            return Result.ok(this.accountSubjectService.findAllList(accountSubjectDto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "批量拉取会计科目数据")
    @PostMapping("pullAccountSubjectList")
    public Result<?> pullAccountSubjectList() {
        try {
            this.accountSubjectService.pullAccountSubjectList();
            return Result.ok("数据拉取成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @GetMapping("findAccountSubjectByCode")
    public Result<?> findAccountSubjectByCode(@RequestParam("codes") List<String> codes){

        try {

            List<AccountSubjectVo> resultList = this.accountSubjectService.findAccountSubjectByCode(codes);

            return Result.ok(resultList);
        }catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PostMapping("findListByCode")
    public Result<List<AccountSubjectVo>> findListByCode(@RequestBody List<String> codes){
        try {
            List<AccountSubjectVo> listByCode = this.accountSubjectService.findListByCode(codes);
            return Result.ok(listByCode);
        }catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
