package com.biz.crm.tpm.business.account.subject.local.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.subject.sdk.dto.CustomerOwnershipDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.CustomerOwnershipService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.CustomerOwnershipVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liyang
 * @date 2023/12/15
 */
@RestController
@RequestMapping("/v1/customerOwnership")
@Slf4j
@Api(tags = "客户归属关系控制层")
public class CustomerOwnershipController {

  @Autowired
  private CustomerOwnershipService customerOwnershipService;

  @ApiOperation(value = "查询分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<CustomerOwnershipVo>> findByConditions(@PageableDefault(50) Pageable pageable, CustomerOwnershipDto paginationDto) {
    try {
      return Result.ok(customerOwnershipService.findByConditions(pageable, paginationDto));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam List<String> ids){
    try {
      log.info("客户归属关系删除id:{}", JSON.toJSONString(ids));
      customerOwnershipService.delete(ids);
      return Result.ok();
    } catch (Exception e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
