package com.biz.crm.tpm.business.account.subject.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author huojia
 * @date 2022年10月27日 16:31
 */
@ApiModel(value = "AccountSubjectEntity", description = "TPM-会计科目")
@TableName("tpm_account_subject")
@Getter
@Setter
@Table(name = "tpm_account_subject", indexes = {@Index(name = "tpm_account_subject_index1", columnList = "account_subject_code")})
@Entity(name = "tpm_account_subject")
@org.hibernate.annotations.Table(appliesTo = "tpm_account_subject", comment = "TPM-会计科目")
public class AccountSubjectEntity extends TenantFlagOpEntity {

    /**
     * 会计科目编码
     */
    @ApiModelProperty(name = "会计科目编码", notes = "")
    @Column(name = "account_subject_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '会计科目编码 '")
    private String accountSubjectCode;

    /**
     * 会计科目名称
     */
    @ApiModelProperty(name = "会计科目名称", notes = "")
    @Column(name = "account_subject_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '会计科目名称 '")
    private String accountSubjectName;

}
