package com.biz.crm.tpm.business.account.subject.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import lombok.Getter;
import lombok.Setter;

/**
 * 客户归属关系
 *
 * @author liyang
 * @date 2023/12/15
 */
@ApiModel(value = "CustomerOwnership", description = "TPM-客户归属关系")
@TableName("tpm_customer_ownership")
@Getter
@Setter
@Table(uniqueConstraints = {
    @UniqueConstraint(name = "uc_customerownership", columnNames = {"cost_center_code"})
})
@Entity(name = "tpm_customer_ownership")
@org.hibernate.annotations.Table(appliesTo = "tpm_customer_ownership", comment = "TPM-客户归属关系")
public class CustomerOwnership extends TenantFlagOpEntity {

  @ApiModelProperty("业态编码")
  @Column(name = "business_format_code", length = 60, columnDefinition = "varchar(60) COMMENT '业态编码'")
  private String businessFormatCode;

  @ApiModelProperty("业务单元编码")
  @Column(name = "business_unit_code", length = 60, columnDefinition = "varchar(60) COMMENT '业务单元编码'")
  private String businessUnitCode;

  @ApiModelProperty("渠道")
  @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道'")
  private String channelCode;

  @ApiModelProperty("渠道名称")
  @Column(name = "channel_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道名称'")
  private String channelName;

  @ApiModelProperty("所属销售机构编码")
  @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构编码")
  @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
  private String salesInstitutionErpCode;

  @ApiModelProperty("所属销售机构")
  @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
  private String salesInstitutionName;

  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  @ApiModelProperty("客户mdg编码")
  @Column(name = "customer_erp_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户mdg编码'")
  private String customerErpCode;

  @ApiModelProperty("客户名称")
  @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
  private String customerName;

  @ApiModelProperty("预算所属客户编码")
  @Column(name = "customer_profit_loss_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预算所属客户编码'")
  private String customerProfitLossCode;

  @ApiModelProperty("预算所属客户ERP编码")
  @Column(name = "customer_profit_loss_erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预算所属客户ERP编码'")
  private String customerProfitLossErpCode;

  @ApiModelProperty("预算所属客户名称")
  @Column(name = "customer_profit_loss_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算所属客户名称'")
  private String customerProfitLossName;

  @ApiModelProperty("成本中心编码")
  @Column(name = "cost_center_code",length = 64, columnDefinition = "varchar(64) COMMENT '成本中心编码'")
  private String costCenterCode;

  @ApiModelProperty("成本中心名称")
  @Column(name = "cost_center_name",length = 128, columnDefinition = "varchar(128) COMMENT '成本中心名称'")
  private String costCenterName;

  @ApiModelProperty("平台")
  @Column(name = "platform", length = 128, columnDefinition = "VARCHAR(128) COMMENT '平台'")
  private String platform;

  @ApiModelProperty("部门")
  @Column(name = "department", length = 128, columnDefinition = "VARCHAR(128) COMMENT '部门'")
  private String department;

  @ApiModelProperty("部门-分析")
  @Column(name = "department_analysis", length = 128, columnDefinition = "VARCHAR(128) COMMENT '部门-分析'")
  private String departmentAnalysis;


}
