package com.biz.crm.tpm.business.account.subject.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户归属关系导入模型
 * @author liyang
 * @date 2023/12/15
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class CustomerOwnershipImportVo extends CrmExcelVo {
  
  @CrmExcelColumn("业态编码")
  private String businessFormatCode;

  @CrmExcelColumn("业务单元编码")
  private String businessUnitCode;

  @CrmExcelColumn("渠道编码")
  private String channelCode;

  @CrmExcelColumn("渠道名称")
  private String channelName;

//  @CrmExcelColumn("销售机构编码")
  private String salesInstitutionCode;

  @CrmExcelColumn("销售机构编码")
  private String salesInstitutionErpCode;

  @CrmExcelColumn("销售机构")
  private String salesInstitutionName;

//  @CrmExcelColumn("客户编码")
  private String customerCode;

  @CrmExcelColumn("客户编码")
  private String customerErpCode;

  @CrmExcelColumn("客户名称")
  private String customerName;

//  @CrmExcelColumn("预算所属客户编码")
  private String customerProfitLossCode;

  @CrmExcelColumn("预算所属客户编码")
  private String customerProfitLossErpCode;

  @CrmExcelColumn("预算所属客户名称")
  private String customerProfitLossName;

  @CrmExcelColumn("成本中心编码")
  private String costCenterCode;

  @CrmExcelColumn("成本中心名称")
  private String costCenterName;

  @CrmExcelColumn("平台")
  private String platform;

  @CrmExcelColumn("部门")
  private String department;

  @CrmExcelColumn("部门-分析")
  private String departmentAnalysis;
}
