package com.biz.crm.tpm.business.account.subject.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 16:48
 */
public interface AccountSubjectMapper extends BaseMapper<AccountSubjectEntity> {

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo>
     * @author huojia
     * @date 2022/10/27 16:53
     **/
    Page<AccountSubjectVo> findByConditions(Page<AccountSubjectVo> page, @Param("dto") AccountSubjectDto dto);

    /**
     * 下拉查询
     * @param dto
     * @param limitSize
     * @return
     */
    List<AccountSubjectVo> findSelectList(@Param("dto") AccountSubjectSelectDto dto, @Param("limitSize") int limitSize);
}
