package com.biz.crm.tpm.business.account.subject.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.constant.CommonSelectConstant;
import com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity;
import com.biz.crm.tpm.business.account.subject.local.mapper.AccountSubjectMapper;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author huojia
 * @date 2022年10月27日 16:47
 */
@Component
public class AccountSubjectRepository extends ServiceImpl<AccountSubjectMapper, AccountSubjectEntity> {

    @Autowired(required = false)
    private AccountSubjectMapper accountSubjectMapper;
    /**
     * 批量查询
     *
     * @author huojia
     * @date 2022/12/7 22:15
     * @param accountSubjectCodeList
     * @return java.util.List<com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity>
     **/
    public List<AccountSubjectEntity> findBySupplierCodes(List<String> accountSubjectCodeList) {
        if (CollectionUtils.isEmpty(accountSubjectCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(AccountSubjectEntity::getAccountSubjectCode, accountSubjectCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public List<AccountSubjectVo> findSelectList(AccountSubjectSelectDto dto) {
        if (StringUtils.isNotEmpty(dto.getSelectedCode())) {
            List<String> selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return accountSubjectMapper.findSelectList(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }
}
