package com.biz.crm.tpm.business.account.subject.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity;
import com.biz.crm.tpm.business.account.subject.local.entity.CustomerOwnership;
import com.biz.crm.tpm.business.account.subject.local.mapper.CustomerOwnershipMapper;
import com.biz.crm.tpm.business.account.subject.sdk.dto.CustomerOwnershipDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.CustomerOwnershipVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 客户归属关系-Repository
 * @author liyang
 * @date 2023/12/15
 */
@Component
public class CustomerOwnershipRepository extends ServiceImpl<CustomerOwnershipMapper, CustomerOwnership> {

  public Page<CustomerOwnershipVo> findByConditions(Page<CustomerOwnershipVo> page, CustomerOwnershipDto customerOwnershipDto) {
    customerOwnershipDto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(page, customerOwnershipDto);
  }

  public void delete(List<String> ids) {
    if (!CollectionUtils.isEmpty(ids)) {
      this.lambdaUpdate().in(CustomerOwnership::getId, ids).remove();
    }
  }

  public List<String> checkExist(List<String> costCenterCodes) {
    List<String> existCostCenterCodes = new ArrayList<>();
    if (CollectionUtils.isEmpty(costCenterCodes)) {
      return existCostCenterCodes;
    }
    List<CustomerOwnership> list = this.lambdaQuery()
        .in(CustomerOwnership::getCostCenterCode, costCenterCodes)
        .list();
    if (!CollectionUtils.isEmpty(list)) {
      existCostCenterCodes.addAll(list.stream().map(CustomerOwnership::getCostCenterCode)
          .filter(Objects::nonNull).distinct().collect(Collectors.toList()));
    }
    return existCostCenterCodes;
  }
}
