package com.biz.crm.tpm.business.account.subject.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 会计科目自动更新定时任务     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class AccountSubjectAutoSyncXxlJob {


    @Autowired(required = false)
    private AccountSubjectService accountSubjectService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 会计科目自动更新定时任务
     */
    @DynamicTaskService(cornExpression = "0 30 1 * * ?", taskDesc = "会计科目自动更新定时任务")
    public void autoSyncXxlJob() {
        log.info("=====>    会计科目同步[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        accountSubjectService.pullAccountSubjectList();
        log.info("=====>    会计科目同步[{}] end    <=====", DateUtil.dateStrNowAll());

    }

}
