package com.biz.crm.tpm.business.account.subject.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.account.subject.local.entity.CustomerOwnership;
import com.biz.crm.tpm.business.account.subject.local.repository.CustomerOwnershipRepository;
import com.biz.crm.tpm.business.account.subject.sdk.dto.CustomerOwnershipDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.CustomerOwnershipService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.CustomerOwnershipVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 客户归属关系服务层
 *
 * @author liyang
 * @date 2023/12/15
 */
@Service
@Slf4j
public class CustomerOwnershipServiceImpl implements CustomerOwnershipService {

  @Autowired
  private CustomerOwnershipRepository customerOwnershipRepository;

  @Override
  public Page<CustomerOwnershipVo> findByConditions(Pageable pageable, CustomerOwnershipDto customerOwnershipDto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    customerOwnershipDto = ObjectUtils.defaultIfNull(customerOwnershipDto, new CustomerOwnershipDto());
    Page<CustomerOwnershipVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return customerOwnershipRepository.findByConditions(page, customerOwnershipDto);
  }

  @Override
  public void delete(List<String> ids) {
    customerOwnershipRepository.delete(ids);
  }

  @Transactional(rollbackFor = Exception.class)
  @Override
  public void importSave(List<CustomerOwnershipDto> dtoList) {
    List<CustomerOwnership> list = new ArrayList<>(dtoList.size());
    for (CustomerOwnershipDto dto : dtoList) {
      CustomerOwnership entity = new CustomerOwnership();
      BeanUtils.copyProperties(dto, entity);
      entity.setTenantCode(TenantUtils.getTenantCode());
      entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      list.add(entity);
    }
    customerOwnershipRepository.saveBatch(list);
  }

  @Override
  public List<String> checkExist(List<String> costCenterCodes) {
    return customerOwnershipRepository.checkExist(costCenterCodes);
  }
}
