/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.account.subject.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.account.subject.local.imports.vo.CustomerOwnershipImportVo;
import com.biz.crm.tpm.business.account.subject.sdk.dto.CustomerOwnershipDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.CustomerOwnershipService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerOwnershipImportProcess
implements ImportProcess<CustomerOwnershipImportVo> {
    private static final Logger log = LoggerFactory.getLogger(CustomerOwnershipImportProcess.class);
    @Autowired
    private CustomerOwnershipService customerOwnershipService;
    @Autowired
    private SalesOrgVoService salesOrgVoService;
    @Autowired
    private CustomerChannelVoService customerChannelVoService;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, CustomerOwnershipImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
            List<CustomerOwnershipDto> importList = this.validate(data, errorMap);
            if (errorMap.size() > 0) {
                return errorMap;
            }
            if (!CollectionUtils.isEmpty(importList)) {
                this.customerOwnershipService.importSave(importList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                throw new IllegalArgumentException("\u7a7a\u6307\u9488\u5f02\u5e38");
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        return null;
    }

    private List<CustomerOwnershipDto> validate(LinkedHashMap<Integer, CustomerOwnershipImportVo> data, Map<Integer, String> errorMap) {
        List costCenterVoList;
        List customerVos;
        List customerVos2;
        List customerChannelVos;
        List salesOrgVos;
        ArrayList<CustomerOwnershipImportVo> rowDataList = new ArrayList<CustomerOwnershipImportVo>(data.values());
        HashSet<String> channelCodeSet = new HashSet<String>(rowDataList.size());
        HashSet<String> salesInstitutionCodeSet = new HashSet<String>(rowDataList.size());
        HashSet<String> customerCodeSet = new HashSet<String>(rowDataList.size());
        HashSet<String> customerProfitLossCodeSet = new HashSet<String>(rowDataList.size());
        HashSet<String> costCenterCodeSet = new HashSet<String>(rowDataList.size());
        for (int i = 0; i < rowDataList.size(); ++i) {
            String costCenterCode;
            String customerProfitLossErpCode;
            String customerErpCode;
            String channelCode;
            CustomerOwnershipImportVo importVo = (CustomerOwnershipImportVo)((Object)rowDataList.get(i));
            String businessFormatCode = importVo.getBusinessFormatCode();
            if (businessFormatCode == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u4e1a\u6001\u7f16\u7801\u672a\u4f20").concat(","));
            }
            if ((channelCode = importVo.getChannelCode()) == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u6e20\u9053\u7f16\u7801\u672a\u4f20").concat(","));
            } else {
                channelCodeSet.add(channelCode);
            }
            String salesInstitutionErpCode = importVo.getSalesInstitutionErpCode();
            if (salesInstitutionErpCode == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u9500\u552e\u673a\u6784\u7f16\u7801\u672a\u4f20").concat(","));
            }
            if ((customerErpCode = importVo.getCustomerErpCode()) == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u5ba2\u6237\u7f16\u7801\u672a\u4f20").concat(","));
            }
            if ((customerProfitLossErpCode = importVo.getCustomerProfitLossErpCode()) == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u9884\u7b97\u6240\u5c5e\u5ba2\u6237\u7f16\u7801\u672a\u4f20").concat(","));
            }
            if ((costCenterCode = importVo.getCostCenterCode()) == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u672a\u4f20").concat(","));
            } else {
                costCenterCodeSet.add(costCenterCode);
            }
            String platform = importVo.getPlatform();
            if (platform == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u5e73\u53f0\u672a\u4f20").concat(","));
            }
            String salesInstitutionCode = importVo.getChannelCode() + importVo.getBusinessFormatCode() + importVo.getSalesInstitutionErpCode();
            importVo.setSalesInstitutionCode(salesInstitutionCode);
            salesInstitutionCodeSet.add(importVo.getSalesInstitutionCode());
            String customerCode = importVo.getCustomerErpCode() + importVo.getSalesInstitutionErpCode() + importVo.getChannelCode() + importVo.getBusinessFormatCode();
            importVo.setCustomerCode(customerCode);
            customerCodeSet.add(importVo.getCustomerCode());
            String customerProfitLossCode = importVo.getCustomerProfitLossErpCode() + importVo.getSalesInstitutionErpCode() + importVo.getChannelCode() + importVo.getBusinessFormatCode();
            importVo.setCustomerProfitLossCode(customerProfitLossCode);
            customerProfitLossCodeSet.add(importVo.getCustomerProfitLossCode());
        }
        List existCostCenterCodes = this.customerOwnershipService.checkExist((List)Lists.newArrayList(costCenterCodeSet));
        HashMap<String, String> salesOrgVoMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(salesInstitutionCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesInstitutionCodeSet))))) {
            salesOrgVoMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getSalesOrgName)));
        }
        HashMap<String, String> customerChannelVoMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(channelCodeSet) && !CollectionUtils.isEmpty((Collection)(customerChannelVos = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet))))) {
            customerChannelVoMap.putAll(customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, CustomerChannelVo::getCustomerChannelName)));
        }
        HashMap<String, String> customerVoMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos2 = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap.putAll(customerVos2.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, CustomerVo::getCustomerName)));
        }
        HashMap<String, String> customerProfitLossVoMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(customerProfitLossCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerProfitLossCodeSet))))) {
            customerProfitLossVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, CustomerVo::getCustomerName)));
        }
        HashMap<String, String> costCenterCodeVoMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(costCenterCodeSet) && !CollectionUtils.isEmpty((Collection)(costCenterVoList = this.costCenterVoService.findByCodeList(new ArrayList(costCenterCodeSet))))) {
            costCenterCodeVoMap.putAll(costCenterVoList.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, CostCenterVo::getCostCenterName)));
        }
        for (int i = 0; i < rowDataList.size(); ++i) {
            CustomerOwnershipImportVo importVo = (CustomerOwnershipImportVo)((Object)rowDataList.get(i));
            String channelName = (String)customerChannelVoMap.get(importVo.getChannelCode());
            if (channelName == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u6e20\u9053\u540d\u79f0\u4e0d\u5b58\u5728").concat(","));
            } else {
                importVo.setChannelName(channelName);
            }
            String salesInstitutionName = (String)salesOrgVoMap.get(importVo.getSalesInstitutionCode());
            if (salesInstitutionName == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u9500\u552e\u673a\u6784\u540d\u79f0\u4e0d\u5b58\u5728").concat(","));
            } else {
                importVo.setSalesInstitutionName(salesInstitutionName);
            }
            String customerName = (String)customerVoMap.get(importVo.getCustomerCode());
            if (customerName == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u5ba2\u6237\u540d\u79f0\u4e0d\u5b58\u5728").concat(","));
            } else {
                importVo.setCustomerName(customerName);
            }
            String customerProfitLossName = (String)customerProfitLossVoMap.get(importVo.getCustomerProfitLossCode());
            if (customerProfitLossName == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u9884\u7b97\u6240\u5c5e\u5ba2\u6237\u540d\u79f0\u4e0d\u5b58\u5728").concat(","));
            } else {
                importVo.setCustomerProfitLossName(customerProfitLossName);
            }
            String costCenterName = (String)costCenterCodeVoMap.get(importVo.getCostCenterCode());
            if (costCenterName == null) {
                errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u5b58\u5728").concat(","));
            } else {
                importVo.setCostCenterName(costCenterName);
            }
            if (!existCostCenterCodes.contains(importVo.getCostCenterCode())) continue;
            errorMap.put(i, this.initNullString(errorMap.get(i)).concat("\u8be5\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u5df2\u5b58\u5728\u5ba2\u6237\u5f52\u5c5e\u5173\u7cfb\u4e0d\u53ef\u91cd\u590d").concat(","));
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(rowDataList, CustomerOwnershipImportVo.class, CustomerOwnershipDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private String initNullString(String s) {
        return s == null ? "" : s;
    }

    public Class<CustomerOwnershipImportVo> findCrmExcelVoClass() {
        return CustomerOwnershipImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_CUSTOMER_OWNERSHIP_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5ba2\u6237\u5f52\u5c5e\u5173\u7cfb\u5bfc\u5165";
    }
}

