/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.account.subject.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity;
import com.biz.crm.tpm.business.account.subject.local.mapper.AccountSubjectMapper;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AccountSubjectRepository
extends ServiceImpl<AccountSubjectMapper, AccountSubjectEntity> {
    @Autowired(required=false)
    private AccountSubjectMapper accountSubjectMapper;

    public List<AccountSubjectEntity> findBySupplierCodes(List<String> accountSubjectCodeList) {
        if (CollectionUtils.isEmpty(accountSubjectCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AccountSubjectEntity::getAccountSubjectCode, accountSubjectCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AccountSubjectVo> findSelectList(AccountSubjectSelectDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return this.accountSubjectMapper.findSelectList(dto, 50);
    }
}

