/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.account.subject.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.account.subject.local.entity.CustomerOwnership;
import com.biz.crm.tpm.business.account.subject.local.mapper.CustomerOwnershipMapper;
import com.biz.crm.tpm.business.account.subject.sdk.dto.CustomerOwnershipDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.CustomerOwnershipVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerOwnershipRepository
extends ServiceImpl<CustomerOwnershipMapper, CustomerOwnership> {
    public Page<CustomerOwnershipVo> findByConditions(Page<CustomerOwnershipVo> page, CustomerOwnershipDto customerOwnershipDto) {
        customerOwnershipDto.setTenantCode(TenantUtils.getTenantCode());
        return ((CustomerOwnershipMapper)this.baseMapper).findByConditions(page, customerOwnershipDto);
    }

    public void delete(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).remove();
        }
    }

    public List<String> checkExist(List<String> costCenterCodes) {
        ArrayList<String> existCostCenterCodes = new ArrayList<String>();
        if (CollectionUtils.isEmpty(costCenterCodes)) {
            return existCostCenterCodes;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CustomerOwnership::getCostCenterCode, costCenterCodes)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            existCostCenterCodes.addAll(list.stream().map(CustomerOwnership::getCostCenterCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        return existCostCenterCodes;
    }
}

