/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.account.subject.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.SapFiAccountSubjectDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.SapFiService;
import com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity;
import com.biz.crm.tpm.business.account.subject.local.mapper.AccountSubjectMapper;
import com.biz.crm.tpm.business.account.subject.local.repository.AccountSubjectRepository;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountSubjectServiceImpl
implements AccountSubjectService {
    private static final Logger log = LoggerFactory.getLogger(AccountSubjectServiceImpl.class);
    @Autowired(required=false)
    private AccountSubjectMapper accountSubjectMapper;
    @Autowired(required=false)
    private AccountSubjectRepository accountSubjectRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SapFiService sapFiService;

    public Page<AccountSubjectVo> findByConditions(Pageable pageable, AccountSubjectDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AccountSubjectDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.accountSubjectMapper.findByConditions((Page<AccountSubjectVo>)page, dto);
    }

    public List<AccountSubjectVo> findAllList(AccountSubjectSelectDto dto) {
        return this.accountSubjectRepository.findSelectList(dto);
    }

    public List<AccountSubjectVo> findListByCode(List<String> codeList) {
        List<AccountSubjectEntity> accountSubjectList = this.accountSubjectRepository.findBySupplierCodes(codeList);
        if (accountSubjectList.isEmpty() || accountSubjectList.size() <= 0) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(accountSubjectList, AccountSubjectEntity.class, AccountSubjectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullAccountSubjectList() {
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List sapFiAccountSubjectVos = this.sapFiService.pullAccountSubjectList(new SapFiAccountSubjectDto());
            if (CollectionUtils.isEmpty((Collection)sapFiAccountSubjectVos)) {
                return;
            }
            HashMap codeMap = new HashMap(8);
            ArrayList<AccountSubjectEntity> pullList = new ArrayList<AccountSubjectEntity>();
            sapFiAccountSubjectVos.forEach(sapFiAccountSubjectVo -> {
                if (StringUtils.isEmpty((CharSequence)sapFiAccountSubjectVo.getSAKNR())) {
                    log.info("\u672c\u6b21\u62c9\u53d6\u6570\u636e[{}]\u4f1a\u8ba1\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)sapFiAccountSubjectVos);
                    return;
                }
                if (codeMap.containsKey(sapFiAccountSubjectVo.getSAKNR())) {
                    log.info("\u672c\u6b21\u62c9\u53d6\u6570\u636e[{}]\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)sapFiAccountSubjectVos);
                    return;
                }
                codeMap.put(sapFiAccountSubjectVo.getSAKNR(), "");
                AccountSubjectEntity accountSubjectEntity = new AccountSubjectEntity();
                accountSubjectEntity.setAccountSubjectCode(sapFiAccountSubjectVo.getSAKNR());
                accountSubjectEntity.setAccountSubjectName(sapFiAccountSubjectVo.getTXT50());
                accountSubjectEntity.setTenantCode(TenantUtils.getTenantCode());
                accountSubjectEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                accountSubjectEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                pullList.add(accountSubjectEntity);
            });
            List<String> accountSubjectCodeList = pullList.stream().map(AccountSubjectEntity::getAccountSubjectCode).collect(Collectors.toList());
            List<AccountSubjectEntity> byCodes = this.accountSubjectRepository.findBySupplierCodes(accountSubjectCodeList);
            if (CollectionUtils.isEmpty(byCodes)) {
                this.saveOrUpdateSapBatch(pullList, null);
                return;
            }
            ArrayList<AccountSubjectEntity> saveList = new ArrayList<AccountSubjectEntity>();
            ArrayList<AccountSubjectEntity> updateList = new ArrayList<AccountSubjectEntity>();
            Map map = byCodes.stream().collect(Collectors.toMap(AccountSubjectEntity::getAccountSubjectCode, Function.identity()));
            pullList.forEach(pull -> {
                if (map.containsKey(pull.getAccountSubjectCode())) {
                    AccountSubjectEntity accountSubjectEntity = (AccountSubjectEntity)((Object)((Object)map.get(pull.getAccountSubjectCode())));
                    accountSubjectEntity.setAccountSubjectCode(pull.getAccountSubjectCode());
                    accountSubjectEntity.setAccountSubjectName(pull.getAccountSubjectName());
                    updateList.add(accountSubjectEntity);
                } else {
                    saveList.add((AccountSubjectEntity)((Object)pull));
                }
            });
            this.saveOrUpdateSapBatch(saveList, updateList);
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    public List<AccountSubjectVo> findAccountSubjectByCode(List<String> codes) {
        List<AccountSubjectEntity> list = this.accountSubjectRepository.findBySupplierCodes(codes);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AccountSubjectEntity.class, AccountSubjectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateSapBatch(List<AccountSubjectEntity> saveList, List<AccountSubjectEntity> updateList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            this.accountSubjectRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.accountSubjectRepository.updateBatchById(updateList);
        }
    }

    public boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u4f1a\u8ba1\u79d1\u76ee\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock("account_subject_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12L);
    }

    public void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u4f1a\u8ba1\u79d1\u76ee\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisLockService.unlock("account_subject_lock:lock:" + yearMonthDay);
    }
}

