/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.account.subject.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.account.subject.local.entity.CustomerOwnership;
import com.biz.crm.tpm.business.account.subject.local.repository.CustomerOwnershipRepository;
import com.biz.crm.tpm.business.account.subject.sdk.dto.CustomerOwnershipDto;
import com.biz.crm.tpm.business.account.subject.sdk.service.CustomerOwnershipService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.CustomerOwnershipVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerOwnershipServiceImpl
implements CustomerOwnershipService {
    private static final Logger log = LoggerFactory.getLogger(CustomerOwnershipServiceImpl.class);
    @Autowired
    private CustomerOwnershipRepository customerOwnershipRepository;

    public Page<CustomerOwnershipVo> findByConditions(Pageable pageable, CustomerOwnershipDto customerOwnershipDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        customerOwnershipDto = (CustomerOwnershipDto)ObjectUtils.defaultIfNull((Object)customerOwnershipDto, (Object)new CustomerOwnershipDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.customerOwnershipRepository.findByConditions((Page<CustomerOwnershipVo>)page, customerOwnershipDto);
    }

    public void delete(List<String> ids) {
        this.customerOwnershipRepository.delete(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<CustomerOwnershipDto> dtoList) {
        ArrayList<CustomerOwnership> list = new ArrayList<CustomerOwnership>(dtoList.size());
        for (CustomerOwnershipDto dto : dtoList) {
            CustomerOwnership entity = new CustomerOwnership();
            BeanUtils.copyProperties((Object)dto, (Object)((Object)entity));
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            list.add(entity);
        }
        this.customerOwnershipRepository.saveBatch(list);
    }

    public List<String> checkExist(List<String> costCenterCodes) {
        return this.customerOwnershipRepository.checkExist(costCenterCodes);
    }
}

