package com.biz.crm.tpm.business.account.subject.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author liyang
 * @date 2023/12/15
 */
@ApiModel(value = "CustomerOwnershipDto", description = "TPM-客户归属关系")
@Getter
@Setter
public class CustomerOwnershipDto extends TenantFlagOpDto {

  @ApiModelProperty("业态编码")
  private String businessFormatCode;

  @ApiModelProperty("业务单元编码")
  private String businessUnitCode;

  @ApiModelProperty("渠道编码")
  private String channelCode;

  @ApiModelProperty("渠道名称")
  private String channelName;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionErpCode;

  @ApiModelProperty("所属销售机构")
  private String salesInstitutionName;

  @ApiModelProperty("客户编码")
  private String customerCode;

  @ApiModelProperty("客户mdg编码")
  private String customerErpCode;

  @ApiModelProperty("客户名称")
  private String customerName;

  @ApiModelProperty("预算所属客户编码")
  private String customerProfitLossCode;

  @ApiModelProperty("预算所属客户ERP编码")
  private String customerProfitLossErpCode;

  @ApiModelProperty("预算所属客户名称")
  private String customerProfitLossName;

  @ApiModelProperty("成本中心编码")
  private String costCenterCode;

  @ApiModelProperty("成本中心名称")
  private String costCenterName;

  @ApiModelProperty("平台")
  private String platform;

  @ApiModelProperty("部门")
  private String department;

  @ApiModelProperty("部门-分析")
  private String departmentAnalysis;
}
