package com.biz.crm.tpm.business.account.subject.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectDto;
import com.biz.crm.tpm.business.account.subject.sdk.dto.AccountSubjectSelectDto;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 16:42
 */
public interface AccountSubjectService {

    /**
     * 分页查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo>
     * @author huojia
     * @date 2022/10/27 16:51
     **/
    Page<AccountSubjectVo> findByConditions(Pageable pageable, AccountSubjectDto dto);

    /**
     * 会计科目下拉
     * @param accountSubjectDto
     * @return
     */
    List<AccountSubjectVo> findAllList(AccountSubjectSelectDto accountSubjectDto);

    /**
     * 根据编码查询
     * @param codeList 编码
     * @return List
     */
    List<AccountSubjectVo> findListByCode(List<String> codeList);

    /**
     * 批量拉取会计科目数据
     *
     * @author huojia
     * @date 2022/12/7 22:03
     **/
    void pullAccountSubjectList();

    List<AccountSubjectVo> findAccountSubjectByCode(List<String> codes);
}
