package com.biz.crm.tpm.business.activities.template.config.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.template.config.feign.feign.internal.ActivitiesTemplateConfigFeignImpl;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName ActivitiesTemplateConfigFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ActivitiesTemplateConfigFeignImpl.class)
public interface ActivitiesTemplateConfigFeign {

    @GetMapping("/v1/activitiesTemplateConfig/{id}")
    Result<ActivitiesTemplateConfigDto> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id);

    @PostMapping("/v1/activitiesTemplateConfig")
    Result<ActivitiesTemplateConfigVo> create(@RequestBody ActivitiesTemplateConfigDto dto);

    @PostMapping(value = "/v1/activitiesTemplateConfig/update")
    Result<ActivitiesTemplateConfigVo> update(@RequestBody ActivitiesTemplateConfigDto dto);

    @PostMapping(value = "/v1/activitiesTemplateConfig/delete")
    Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids);
}
