package com.biz.crm.tpm.business.activities.template.config.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.template.config.feign.feign.ActivitiesTemplateConfigFeign;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ActivitiesTemplateConfigFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@Component
@Slf4j
public class ActivitiesTemplateConfigFeignImpl implements FallbackFactory<ActivitiesTemplateConfigFeign> {
    @Override
    public ActivitiesTemplateConfigFeign create(Throwable cause) {
        log.error("活动模板配置进入熔断");
        return new ActivitiesTemplateConfigFeign(){

            @Override
            public Result<ActivitiesTemplateConfigDto> findById(String id) {
                throw new UnsupportedOperationException("查询活动模板配置熔断");
            }

            @Override
            public Result<ActivitiesTemplateConfigVo> create(ActivitiesTemplateConfigDto dto) {
                throw new UnsupportedOperationException("创建活动模板配置熔断");
            }

            @Override
            public Result<ActivitiesTemplateConfigVo> update(ActivitiesTemplateConfigDto dto) {
                throw new UnsupportedOperationException("更新活动模板配置熔断");
            }

            @Override
            public Result<?> delete(List<String> idList) {
                throw new UnsupportedOperationException("删除活动模板配置熔断");
            }
        };
    }
}
