/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.template.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activities.template.config.local.entity.ActivitiesTemplateConfig;
import com.biz.crm.tpm.business.activities.template.config.local.mapper.TpmActivitiesTemplateConfigMapper;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigSearchDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TpmActivitiesTemplateConfigRepository
extends ServiceImpl<TpmActivitiesTemplateConfigMapper, ActivitiesTemplateConfig> {
    @Autowired
    private TpmActivitiesTemplateConfigMapper tpmActivitiesTemplateConfigMapper;

    public ActivitiesTemplateConfig findByCode(String configCode) {
        if (StringUtils.isBlank((CharSequence)configCode)) {
            return null;
        }
        return (ActivitiesTemplateConfig)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiesTemplateConfig.class).eq(ActivitiesTemplateConfig::getConfigCode, (Object)configCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())));
    }

    public List<ActivitiesTemplateConfig> findByCodeList(List<String> configCodeList) {
        if (CollectionUtils.isEmpty(configCodeList)) {
            return Lists.newArrayList();
        }
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivitiesTemplateConfig.class).in(ActivitiesTemplateConfig::getConfigCode, configCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public Page<ActivitiesTemplateConfigVo> findByConditions(Pageable pageable, ActivitiesTemplateConfigSearchDto activitiesTemplateConfig) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivitiesTemplateConfigVo> pageList = this.tpmActivitiesTemplateConfigMapper.findByConditions((Page<ActivitiesTemplateConfigVo>)page, activitiesTemplateConfig);
        return pageList;
    }

    public void removeConfigByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<CommonSelectVo> findActivitiesTemplateConfigSelectList(CommonSelectDto selectDto, ActivitiesTemplateConfigDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)selectDto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(selectDto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.addAll(Arrays.asList(selectDto.getSelectedCode().split(",")));
            selectDto.setSelectedCodeList(selectCodeList);
        }
        return this.tpmActivitiesTemplateConfigMapper.findActivitiesTemplateConfigSelectList(selectDto, dto, 50);
    }

    public List<ActivitiesTemplateConfig> getList(ActivitiesTemplateConfigDto activitiesTemplateConfigDto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)activitiesTemplateConfigDto.getBusinessFormatCode()), ActivitiesTemplateConfig::getBusinessFormatCode, (Object)activitiesTemplateConfigDto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)activitiesTemplateConfigDto.getBusinessUnitCode()), ActivitiesTemplateConfig::getBusinessUnitCode, (Object)activitiesTemplateConfigDto.getBusinessUnitCode())).like(StringUtils.isNotEmpty((CharSequence)activitiesTemplateConfigDto.getConfigName()), ActivitiesTemplateConfig::getConfigName, (Object)activitiesTemplateConfigDto.getConfigName())).eq(StringUtils.isNotEmpty((CharSequence)activitiesTemplateConfigDto.getType()), ActivitiesTemplateConfig::getType, (Object)activitiesTemplateConfigDto.getType())).list();
    }

    public ActivitiesTemplateConfig findById(String id) {
        return (ActivitiesTemplateConfig)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidEntity::getId, (Object)id)).one());
    }

    public List<ActivitiesTemplateConfig> findByIdList(List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, idList)).list();
    }
}

