/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.template.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.template.config.local.entity.ActivitiesTemplateConfig;
import com.biz.crm.tpm.business.activities.template.config.local.entity.ActivitiesTemplateConfigDetail;
import com.biz.crm.tpm.business.activities.template.config.local.repository.TpmActivitiesTemplateConfigDetailRepository;
import com.biz.crm.tpm.business.activities.template.config.local.repository.TpmActivitiesTemplateConfigRepository;
import com.biz.crm.tpm.business.activities.template.config.local.service.TpmActivitiesTemplateConfigService;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDetailDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigSearchDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.SubComActivityDetailPlanTemplateDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.log.ActivitiesTemplateConfigLogEventDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.event.log.ActivitiesTemplateConfigLogEventListener;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.enums.UndertakingFieldEnum;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityConfigRecordService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmActivitiesTemplateConfigService")
public class TpmActivitiesTemplateConfigServiceImpl
implements TpmActivitiesTemplateConfigService {
    @Autowired(required=false)
    private TpmActivitiesTemplateConfigRepository tpmActivitiesTemplateConfigRepository;
    @Autowired(required=false)
    private TpmActivitiesTemplateConfigDetailRepository tpmActivitiesTemplateConfigDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private TpmActivityConfigRecordService tpmActivityConfigRecordService;
    @Autowired(required=false)
    private TpmActivityContractConfigService tpmActivityContractConfigService;

    @Override
    public Page<ActivitiesTemplateConfigVo> findByConditions(Pageable pageable, ActivitiesTemplateConfigSearchDto activitiesTemplateConfig) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(activitiesTemplateConfig)) {
            activitiesTemplateConfig = new ActivitiesTemplateConfigSearchDto();
        }
        return this.tpmActivitiesTemplateConfigRepository.findByConditions(pageable, activitiesTemplateConfig);
    }

    @Override
    public ActivitiesTemplateConfigDto findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivitiesTemplateConfigDto dto = (ActivitiesTemplateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)this.tpmActivitiesTemplateConfigRepository.findById(id), ActivitiesTemplateConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
        List<ActivitiesTemplateConfigDetail> list = this.tpmActivitiesTemplateConfigDetailRepository.findByConfigCode(dto.getConfigCode());
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivitiesTemplateConfigDetail.class, ActivitiesTemplateConfigDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        dto.setDetails(dtoList);
        return dto;
    }

    @Override
    public ActivitiesTemplateConfigVo findByCode(String configCode) {
        if (StringUtils.isBlank((CharSequence)configCode)) {
            return null;
        }
        ActivitiesTemplateConfig entity = this.tpmActivitiesTemplateConfigRepository.findByCode(configCode);
        if (null == entity) {
            return null;
        }
        ActivitiesTemplateConfigVo vo = (ActivitiesTemplateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesTemplateConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ActivitiesTemplateConfigDetail> list = this.tpmActivitiesTemplateConfigDetailRepository.findByConfigCode(vo.getConfigCode());
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivitiesTemplateConfigDetail.class, ActivitiesTemplateConfigDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        vo.setDetails(dtoList);
        return vo;
    }

    @Override
    public List<ActivitiesTemplateConfigVo> findByCodeList(List<String> configCodeList) {
        if (CollectionUtils.isEmpty(configCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivitiesTemplateConfig> configList = this.tpmActivitiesTemplateConfigRepository.findByCodeList(configCodeList);
        if (CollectionUtils.isEmpty(configList)) {
            return Lists.newArrayList();
        }
        List<ActivitiesTemplateConfigDetail> list = this.tpmActivitiesTemplateConfigDetailRepository.findByConfigCodeList(configCodeList);
        Map<String, List<ActivitiesTemplateConfigDetail>> detailMap = list.stream().collect(Collectors.groupingBy(ActivitiesTemplateConfigDetail::getConfigCode));
        ArrayList result = Lists.newArrayList();
        for (ActivitiesTemplateConfig entity : configList) {
            ActivitiesTemplateConfigVo vo = (ActivitiesTemplateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesTemplateConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
            if (detailMap.containsKey(vo.getConfigCode())) {
                List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailMap.get(vo.getConfigCode()), ActivitiesTemplateConfigDetail.class, ActivitiesTemplateConfigDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
                vo.setDetails(dtoList);
            }
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<ActivitiesTemplateConfigVo> findBaseByCodeList(List<String> configCodeList) {
        if (CollectionUtils.isEmpty(configCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivitiesTemplateConfig> configList = this.tpmActivitiesTemplateConfigRepository.findByCodeList(configCodeList);
        if (CollectionUtils.isEmpty(configList)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (ActivitiesTemplateConfig entity : configList) {
            ActivitiesTemplateConfigVo vo = (ActivitiesTemplateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesTemplateConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
            result.add(vo);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivitiesTemplateConfig create(ActivitiesTemplateConfigDto dto) {
        this.createValidate(dto);
        ActivitiesTemplateConfig activitiesTemplateConfig = (ActivitiesTemplateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivitiesTemplateConfig.class, HashSet.class, ArrayList.class, new String[0]));
        List codeList = this.generateCodeService.generateCode("HDMBPZ", 1);
        activitiesTemplateConfig.setConfigCode((String)codeList.get(0));
        activitiesTemplateConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        activitiesTemplateConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activitiesTemplateConfig.setTenantCode(TenantUtils.getTenantCode());
        this.tpmActivitiesTemplateConfigRepository.saveOrUpdate((Object)activitiesTemplateConfig);
        List details = dto.getDetails();
        List detailList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)details, ActivitiesTemplateConfigDetailDto.class, ActivitiesTemplateConfigDetail.class, HashSet.class, ArrayList.class, new String[0]);
        detailList.forEach(e -> {
            e.setConfigCode(activitiesTemplateConfig.getConfigCode());
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        this.tpmActivitiesTemplateConfigDetailRepository.saveBatch(detailList);
        ActivitiesTemplateConfigLogEventDto logEventDto = new ActivitiesTemplateConfigLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = ActivitiesTemplateConfigLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesTemplateConfigLogEventListener.class, (SerializableBiConsumer)onCreate);
        return activitiesTemplateConfig;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivitiesTemplateConfig update(ActivitiesTemplateConfigDto dto) {
        this.updateValidate(dto);
        ActivitiesTemplateConfig activitiesTemplateConfig = (ActivitiesTemplateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivitiesTemplateConfig.class, HashSet.class, ArrayList.class, new String[0]));
        activitiesTemplateConfig.setConfigCode(null);
        activitiesTemplateConfig.setTenantCode(null);
        ActivitiesTemplateConfig entityOld = this.tpmActivitiesTemplateConfigRepository.findById(dto.getId());
        this.tpmActivitiesTemplateConfigRepository.saveOrUpdate((Object)activitiesTemplateConfig);
        List details = dto.getDetails();
        List<String> idListDto = details.stream().filter(e -> e.getId() != null).map(e -> e.getId()).collect(Collectors.toList());
        this.tpmActivitiesTemplateConfigDetailRepository.deleteByIdNotInList(idListDto, dto.getConfigCode());
        List detailList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)details, ActivitiesTemplateConfigDetailDto.class, ActivitiesTemplateConfigDetail.class, HashSet.class, ArrayList.class, new String[0]);
        detailList.forEach(e -> {
            e.setConfigCode(dto.getConfigCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setFormControl(Optional.ofNullable(e.getFormControl()).orElse(""));
        });
        this.tpmActivitiesTemplateConfigDetailRepository.saveOrUpdateBatch(detailList);
        ActivitiesTemplateConfigLogEventDto logEventDto = new ActivitiesTemplateConfigLogEventDto();
        logEventDto.setOriginal((ActivitiesTemplateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entityOld, ActivitiesTemplateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = ActivitiesTemplateConfigLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesTemplateConfigLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return activitiesTemplateConfig;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivitiesTemplateConfig> configList = this.tpmActivitiesTemplateConfigRepository.findByIdList(idList);
        Validate.notEmpty(configList, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.tpmActivitiesTemplateConfigRepository.removeConfigByIds(idList);
        this.tpmActivitiesTemplateConfigDetailRepository.deleteByConfigCodeList(idList);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(configList, ActivitiesTemplateConfig.class, ActivitiesTemplateConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = ActivitiesTemplateConfigLogEventListener::onDelete;
        for (ActivitiesTemplateConfigDto dto : dtoList) {
            ActivitiesTemplateConfigLogEventDto logEventDto = new ActivitiesTemplateConfigLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesTemplateConfigLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List configList = this.tpmActivitiesTemplateConfigRepository.listByIds(idList);
        Validate.notEmpty((Collection)configList, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.tpmActivitiesTemplateConfigRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, idList);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)configList, ActivitiesTemplateConfig.class, ActivitiesTemplateConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onEnable = ActivitiesTemplateConfigLogEventListener::onEnable;
        for (ActivitiesTemplateConfigDto dto : dtoList) {
            ActivitiesTemplateConfigLogEventDto logEventDto = new ActivitiesTemplateConfigLogEventDto();
            logEventDto.setNewest(dto);
            dto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesTemplateConfigLogEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List configList = this.tpmActivitiesTemplateConfigRepository.listByIds(idList);
        Validate.notEmpty((Collection)configList, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.tpmActivitiesTemplateConfigRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, idList);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)configList, ActivitiesTemplateConfig.class, ActivitiesTemplateConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDisable = ActivitiesTemplateConfigLogEventListener::onDisable;
        for (ActivitiesTemplateConfigDto dto : dtoList) {
            ActivitiesTemplateConfigLogEventDto logEventDto = new ActivitiesTemplateConfigLogEventDto();
            logEventDto.setNewest(dto);
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesTemplateConfigLogEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Override
    public List<ActivitiesTemplateConfigDto> getList(ActivitiesTemplateConfigDto activitiesTemplateConfigDto) {
        List<ActivitiesTemplateConfig> list = this.tpmActivitiesTemplateConfigRepository.getList(activitiesTemplateConfigDto);
        Collection activitiesTemplateConfigDtos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)Optional.of(list).orElse(new ArrayList()), ActivitiesTemplateConfig.class, ActivitiesTemplateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activitiesTemplateConfigDtos;
    }

    @Override
    public ActivitiesTemplateConfigVo getItemColumnRecordConfig(SubComActivityDetailPlanTemplateDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getActivityTemplateCode())) {
            return null;
        }
        TpmActivityContractConfigDto tpmActivityContractConfigDto = new TpmActivityContractConfigDto();
        tpmActivityContractConfigDto.setOrgCode(dto.getOrgCode());
        tpmActivityContractConfigDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        List tpmActivityContractConfigVos = this.tpmActivityContractConfigService.listByConditions(tpmActivityContractConfigDto);
        ActivitiesTemplateConfig entity = this.tpmActivitiesTemplateConfigRepository.findByCode(dto.getActivityTemplateCode());
        if (null == entity) {
            return null;
        }
        ActivitiesTemplateConfigVo activitiesTemplateConfigVo = (ActivitiesTemplateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesTemplateConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<ActivitiesTemplateConfigDetail> list = this.tpmActivitiesTemplateConfigDetailRepository.findByConfigCode(activitiesTemplateConfigVo.getConfigCode());
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivitiesTemplateConfigDetail.class, ActivitiesTemplateConfigDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)tpmActivityContractConfigVos)) {
            List fieldList = UndertakingFieldEnum.concertEnumToList();
            List collect = voList.stream().filter(vo -> !fieldList.contains(vo.getField())).collect(Collectors.toList());
            activitiesTemplateConfigVo.setDetails(collect);
        } else {
            activitiesTemplateConfigVo.setDetails(voList);
        }
        return activitiesTemplateConfigVo;
    }

    private void createValidate(ActivitiesTemplateConfigDto activitiesTemplateConfig) {
        Validate.notNull((Object)activitiesTemplateConfig, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.commonValidate(activitiesTemplateConfig);
        activitiesTemplateConfig.setId(null);
    }

    private void updateValidate(ActivitiesTemplateConfigDto activitiesTemplateConfig) {
        Validate.notNull((Object)activitiesTemplateConfig, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.commonValidate(activitiesTemplateConfig);
        Validate.notBlank((CharSequence)activitiesTemplateConfig.getId(), (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void commonValidate(ActivitiesTemplateConfigDto activitiesTemplateConfig) {
        Validate.notBlank((CharSequence)activitiesTemplateConfig.getConfigName(), (String)"\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesTemplateConfig.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesTemplateConfig.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesTemplateConfig.getType(), (String)"\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ActivitiesTemplateConfigTypeEnum.STRATEGY.getCode().equals(activitiesTemplateConfig.getType())) {
            Validate.notBlank((CharSequence)activitiesTemplateConfig.getStrategyTypeCode(), (String)"\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)activitiesTemplateConfig.getStrategyFormType(), (String)"\u7b56\u7565\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else if (ActivitiesTemplateConfigTypeEnum.SCHEME.getCode().equals(activitiesTemplateConfig.getType())) {
            Validate.notBlank((CharSequence)activitiesTemplateConfig.getSchemeTypeCode(), (String)"\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else if (!(ActivitiesTemplateConfigTypeEnum.SCHEME_DETAIL.getCode().equals(activitiesTemplateConfig.getType()) || ActivitiesTemplateConfigTypeEnum.EXPENSE_INITIATION.getCode().equals(activitiesTemplateConfig.getType()) || ActivitiesTemplateConfigTypeEnum.SUB_COM_DETAIL_PLAN.getCode().equals(activitiesTemplateConfig.getType()) || ActivitiesTemplateConfigTypeEnum.DIFF_FEE_DISPOSE.getCode().equals(activitiesTemplateConfig.getType()))) {
            throw new RuntimeException("\u914d\u7f6e\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        List details = activitiesTemplateConfig.getDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)details) ? 1 : 0) != 0, (String)"\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet<String> set = new HashSet<String>(details.size());
        for (ActivitiesTemplateConfigDetailDto detail : details) {
            Validate.notBlank((CharSequence)detail.getField(), (String)"\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)detail.getTitle(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)set.add(detail.getField()), (String)("\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5:" + detail.getField()), (Object[])new Object[0]);
        }
    }

    @Override
    public Map<String, String> findVerticalActivityTypeByCode(List<String> configCodeList) {
        HashMap<String, String> map = new HashMap<String, String>(configCodeList.size());
        if (CollectionUtils.isEmpty(configCodeList)) {
            return map;
        }
        List<ActivitiesTemplateConfig> templateConfigList = this.tpmActivitiesTemplateConfigRepository.findByCodeList(configCodeList);
        if (CollectionUtils.isEmpty(templateConfigList)) {
            return map;
        }
        templateConfigList.forEach(template -> map.put(template.getConfigCode(), template.getVerticalActivityType()));
        return map;
    }
}

