package com.biz.crm.tpm.business.activities.template.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigSearchDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.SubComActivityDetailPlanTemplateDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * 活动模板配置实体类(ActivitiesTemplateConfig)表服务接口-对外
 *
 * @author yaoyongming
 * @since 2022-10-25 17:07:55
 */
public interface ActivitiesTemplateSdkService {

    Page<ActivitiesTemplateConfigVo> findByConditions(Pageable pageable, ActivitiesTemplateConfigSearchDto activitiesTemplateConfig);

    /**
     * 根据编码获取活动配置信息
     * @param configCode 配置编码
     * @return 具体配置信息，含字段明细
     */
    ActivitiesTemplateConfigVo findByCode(String configCode);


    /**
     * 根据编码获取活动配置信息
     * @param configCodeList 配置编码集合
     * @return 具体配置信息，只有基础信息
     */
    List<ActivitiesTemplateConfigVo> findBaseByCodeList(List<String> configCodeList);


    /**
     * 根据编码获取活动配置信息
     * @param configCodeList 配置编码集合
     * @return 具体配置信息，含字段明细
     */
    List<ActivitiesTemplateConfigVo> findByCodeList(List<String> configCodeList);

    /**
     * 活动配置模板下拉
     *
     * @param dto 活动配置模板查询参数
     */
    List<CommonSelectVo> findActivitiesTemplateConfigSelectList(CommonSelectDto selectDto, ActivitiesTemplateConfigDto dto);

    /**
     *
     *
     * @author huojia
     * @date 2022/12/27 11:14
     * @param dto
     * @return com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo
     **/
    ActivitiesTemplateConfigVo getItemColumnRecordConfig(SubComActivityDetailPlanTemplateDto dto);

    /**
     * 查询模板对应的垂直活动分类
     * @param configCodeList 模板编码
     * @return 模板编码与其对应垂直活动分类 map
     */
    Map<String,String> findVerticalActivityTypeByCode(List<String> configCodeList);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ActivitiesTemplateConfigDto findById(String id);

    /**
     * 新增数据
     *
     * @param dto dto对象
     * @return 新增结果
     */
    ActivitiesTemplateConfigVo create(ActivitiesTemplateConfigDto dto);

    /**
     * 修改新据
     *
     * @param dto dto对象
     * @return 修改结果
     */
    ActivitiesTemplateConfigVo update(ActivitiesTemplateConfigDto dto);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);
}
