package com.biz.crm.tpm.business.activities.template.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivitiesTemplateConfigVo", description = "Vo")
public class ActivitiesTemplateConfigVo extends TenantFlagOpVo {

    /**
     * 门店明细
     */
    @ApiModelProperty("门店明细")
    private String storeDetails;
    /**
     * 配置编码
     */
    @ApiModelProperty("配置编码")
    private String configCode;

    /**
     * 配置名称
     */
    @ApiModelProperty("配置名称")
    private String configName;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 配置表类型： strategy 策略配置表， scheme 方案配置表， scheme_detail 细案配置表
     */
    @ApiModelProperty("配置表类型： strategy 策略配置表， scheme 方案配置表， scheme_detail 细案配置表")
    private String type;

    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型")
    private String strategyTypeCode;

    /**
     * 策略形式
     */
    @ApiModelProperty("策略形式")
    private String strategyFormType;

    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    private String schemeTypeCode;

    /**
     * 明细列表
     */
    @ApiModelProperty("明细列表")
    private List<ActivitiesTemplateConfigDetailVo> details;

    /**
     * 推送牛人管家分类
     *      字典编码：vertical_activity_type
     */
    @ApiModelProperty("垂直活动类型")
    private String verticalActivityType;

    @ApiModelProperty("是否自动生成细案")
    private String isAutoCreateActivityDetailPlan;

    @ApiModelProperty("生成规则(字典编码：generate_rule)")
    private String generateRule;

    @ApiModelProperty("关联细案模板")
    private String relateDetailPlanTemplate;
}
