/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.fields.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.tpm.business.activities.dynamic.template.service.DynamicFormServiceResolver;
import com.biz.crm.tpm.business.activities.fields.dto.ActivitiesFieldsCollectTemplateContextDto;
import com.biz.crm.tpm.business.activities.fields.entity.ActivitiesFieldsCollectTemplate;
import com.biz.crm.tpm.business.activities.fields.repository.ActivitiesFieldsCollectTemplateRepository;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesFieldsCollectTemplateDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesFieldsCollectTemplateService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesFieldsCollectTemplateVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BaseActivityItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivitiesFieldsCollectTemplateServiceImpl
implements ActivitiesFieldsCollectTemplateService {
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private ActivitiesFieldsCollectTemplateRepository activitiesFieldsCollectTemplateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicFormServiceResolver dynamicFormServiceResolver;

    public Page<ActivitiesFieldsCollectTemplateVo> findByConditions(Pageable pageable, ActivitiesFieldsCollectTemplateDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new ActivitiesFieldsCollectTemplateDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.activitiesFieldsCollectTemplateRepository.findByConditions(pageable, dto);
    }

    @Transactional
    public ActivitiesFieldsCollectTemplateVo create(JSONObject json) {
        ActivitiesFieldsCollectTemplateDto dto = this.createValidation(json);
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        ActivitiesFieldsCollectTemplate entity = (ActivitiesFieldsCollectTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivitiesFieldsCollectTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.activitiesFieldsCollectTemplateRepository.save((Object)entity);
        String parentCode = entity.getCode();
        DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(parentCode, entity.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
        Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
        Class calzz = this.dynamicFormServiceResolver.getDynamicFormClass(entity.getDynamicFormCode());
        Validate.notNull((Object)calzz, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u52a8\u6001\u6a21\u677f\u7c7b\u4fe1\u606f", (Object[])new Object[]{entity.getDynamicFormCode()});
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = (ActivitiesFieldsCollectTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesFieldsCollectTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.transfer(activitiesFieldsCollectTemplateVo, calzz);
        dynamicFormService.createDynamicDetails((Object)activitiesFieldsCollectTemplateVo, parentCode);
        return activitiesFieldsCollectTemplateVo;
    }

    public ActivitiesFieldsCollectTemplateVo update(JSONObject json) {
        ActivitiesFieldsCollectTemplateDto dto = this.updateValidation(json);
        ActivitiesFieldsCollectTemplateVo sourceActivitiesFieldsCollectTemplateVo = this.findByCode(dto.getCode());
        Validate.notNull((Object)sourceActivitiesFieldsCollectTemplateVo, (String)"\u6839\u636e\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{dto.getCode()});
        ActivitiesFieldsCollectTemplateContextDto contextDto = this.buildActivityContextDto(sourceActivitiesFieldsCollectTemplateVo, dto, false);
        ActivitiesFieldsCollectTemplate dbActivitiesFieldsCollectTemplate = (ActivitiesFieldsCollectTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)sourceActivitiesFieldsCollectTemplateVo, ActivitiesFieldsCollectTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        dbActivitiesFieldsCollectTemplate.setDynamicFormCode(dto.getDynamicFormCode());
        dbActivitiesFieldsCollectTemplate.setRemark(dto.getRemark());
        return this.processDynamicFormsForUpdate(dbActivitiesFieldsCollectTemplate, contextDto);
    }

    public ActivitiesFieldsCollectTemplateVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ActivitiesFieldsCollectTemplate activitiesFieldsCollectTemplate = this.activitiesFieldsCollectTemplateRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        if (activitiesFieldsCollectTemplate == null) {
            return null;
        }
        DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(activitiesFieldsCollectTemplate.getCode(), activitiesFieldsCollectTemplate.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = (ActivitiesFieldsCollectTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesFieldsCollectTemplate, ActivitiesFieldsCollectTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (dynamicFormService == null) {
            return activitiesFieldsCollectTemplateVo;
        }
        dynamicFormService.perfectDynamicDetails((Object)activitiesFieldsCollectTemplateVo, activitiesFieldsCollectTemplateVo.getCode());
        return activitiesFieldsCollectTemplateVo;
    }

    public List<ActivitiesFieldsCollectTemplateVo> findByActivityDetailCode(String activityDetailCode) {
        if (StringUtils.isBlank((CharSequence)activityDetailCode)) {
            return Lists.newArrayList();
        }
        List<ActivitiesFieldsCollectTemplate> activitiesFieldsCollectTemplates = this.activitiesFieldsCollectTemplateRepository.findByActivityDetailCodeAndTenantCode(activityDetailCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(activitiesFieldsCollectTemplates)) {
            return Lists.newArrayList();
        }
        ArrayList collectTemplateVos = Lists.newArrayList();
        for (ActivitiesFieldsCollectTemplate activitiesFieldsCollectTemplate : activitiesFieldsCollectTemplates) {
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(activitiesFieldsCollectTemplate.getCode(), activitiesFieldsCollectTemplate.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
            ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = (ActivitiesFieldsCollectTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesFieldsCollectTemplate, ActivitiesFieldsCollectTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
            if (dynamicFormService == null) continue;
            dynamicFormService.perfectDynamicDetails((Object)activitiesFieldsCollectTemplateVo, activitiesFieldsCollectTemplateVo.getCode());
            collectTemplateVos.add(activitiesFieldsCollectTemplateVo);
        }
        return collectTemplateVos;
    }

    public ActivitiesFieldsCollectTemplateVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivitiesFieldsCollectTemplate activitiesFieldsCollectTemplate = (ActivitiesFieldsCollectTemplate)((Object)this.activitiesFieldsCollectTemplateRepository.getById((Serializable)((Object)id)));
        if (activitiesFieldsCollectTemplate == null) {
            return null;
        }
        DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(activitiesFieldsCollectTemplate.getCode(), activitiesFieldsCollectTemplate.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = (ActivitiesFieldsCollectTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesFieldsCollectTemplate, ActivitiesFieldsCollectTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (dynamicFormService == null) {
            return activitiesFieldsCollectTemplateVo;
        }
        dynamicFormService.perfectDynamicDetails((Object)activitiesFieldsCollectTemplateVo, activitiesFieldsCollectTemplateVo.getCode());
        return activitiesFieldsCollectTemplateVo;
    }

    public List<ActivitiesFieldsCollectTemplateVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List activitiesFieldsCollectTemplates = this.activitiesFieldsCollectTemplateRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)activitiesFieldsCollectTemplates)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)activitiesFieldsCollectTemplates, ActivitiesFieldsCollectTemplate.class, ActivitiesFieldsCollectTemplateVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public void delete(Set<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivitiesFieldsCollectTemplateVo> activitiesFieldsCollectTemplateVos = this.findByIds(ids);
        Validate.notEmpty(activitiesFieldsCollectTemplateVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        for (ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplate : activitiesFieldsCollectTemplateVos) {
            String parentCode = activitiesFieldsCollectTemplate.getCode();
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(activitiesFieldsCollectTemplate.getCode(), activitiesFieldsCollectTemplate.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
            Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
            dynamicFormService.deleteDynamicDetails(parentCode);
        }
        this.activitiesFieldsCollectTemplateRepository.deleteByIds(Lists.newArrayList(ids));
    }

    private ActivitiesFieldsCollectTemplateDto createValidation(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ActivitiesFieldsCollectTemplateDto dto = (ActivitiesFieldsCollectTemplateDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), ActivitiesFieldsCollectTemplateDto.class);
        this.createValidation(dto);
        return dto;
    }

    private void createValidation(ActivitiesFieldsCollectTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        this.validateBase(dto);
        this.validateRepeatability(dto, true);
        String ruleCode = StringUtils.join((Object[])new String[]{"AFCT", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.notEmpty((Collection)codeList, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        dto.setCode((String)codeList.get(0));
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)dto.getCode(), (String)pattern, (String)"\u7f16\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210\uff0c\u4e14\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6700\u7ec8\u7f16\u7801\u90fd\u5c06\u88ab\u5927\u5199", (Object[])new Object[0]);
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = this.findByCode(dto.getCode());
        Validate.isTrue((activitiesFieldsCollectTemplateVo == null ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
    }

    private void validateBase(ActivitiesFieldsCollectTemplateDto dto) {
        Validate.notBlank((CharSequence)dto.getDynamicFormCode(), (String)"\u5173\u8054\u7684\u52a8\u6001\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Map)dto.getItems(), (String)"\u5173\u8054\u7684\u52a8\u6001\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBtNo(), (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActivityDetailCode(), (String)"\u5173\u8054\u7684\u660e\u7ec6\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validateRepeatability(ActivitiesFieldsCollectTemplateDto dto, boolean isAdd) {
        ActivitiesFieldsCollectTemplate template = this.activitiesFieldsCollectTemplateRepository.findByBtNoAndTenantCode(dto.getBtNo(), TenantUtils.getTenantCode());
        if (isAdd) {
            Validate.isTrue((template == null ? 1 : 0) != 0, (String)"\u6279\u6b21\u53f7\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{dto.getBtNo()});
        } else {
            Validate.notNull((Object)((Object)template), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u6279\u6b21\u53f7\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{dto.getBtNo()});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)template.getId(), (CharSequence)dto.getId()), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u6279\u6b21\u53f7\u3010%s\u3011\uff0c\u83b7\u53d6\u5230\u6570\u636e\u4e0e\u4f20\u5165\u6570\u636e\u4e3b\u952e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{dto.getBtNo()});
        }
    }

    private ActivitiesFieldsCollectTemplateDto updateValidation(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ActivitiesFieldsCollectTemplateDto dto = (ActivitiesFieldsCollectTemplateDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), ActivitiesFieldsCollectTemplateDto.class);
        this.updateValidation(dto);
        return dto;
    }

    private void updateValidation(ActivitiesFieldsCollectTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u66f4\u65b0\u65f6\uff0c\u4e3b\u952eid\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = this.findById(dto.getId());
        Validate.notNull((Object)activitiesFieldsCollectTemplateVo, (String)"\u6839\u636e\u63d0\u4f9b\u7684id\u4e3b\u952e\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)dto.getCode(), (CharSequence)activitiesFieldsCollectTemplateVo.getCode()), (String)"\u4f20\u5165\u7684\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6a21\u677f\u7f16\u7801\u4e0e\u6570\u636e\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.validateBase(dto);
        this.validateRepeatability(dto, false);
    }

    private ActivitiesFieldsCollectTemplateContextDto buildActivityContextDto(ActivitiesFieldsCollectTemplateVo sourceActivity, ActivitiesFieldsCollectTemplateDto targetActivity, boolean addOperate) {
        ActivitiesFieldsCollectTemplateContextDto contextDto = new ActivitiesFieldsCollectTemplateContextDto();
        Validate.notNull((Object)targetActivity, (String)"\u6700\u65b0\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        contextDto.setTargetActivity(targetActivity);
        if (!addOperate) {
            Validate.notNull((Object)sourceActivity, (String)"\u5386\u53f2\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            contextDto.setSourceActivity(sourceActivity);
        }
        return contextDto;
    }

    public Map<String, BaseActivityItemVo> findByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return Maps.newHashMap();
        }
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = this.findByCode(parentCode);
        if (activitiesFieldsCollectTemplateVo == null || CollectionUtils.isEmpty((Map)activitiesFieldsCollectTemplateVo.getItems())) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : activitiesFieldsCollectTemplateVo.getItems().entrySet()) {
            BaseActivityItemVo itemVos = (BaseActivityItemVo)entry.getValue();
            result.put(entry.getKey(), itemVos);
        }
        return result;
    }

    private ActivitiesFieldsCollectTemplateVo processDynamicFormsForUpdate(ActivitiesFieldsCollectTemplate entity, ActivitiesFieldsCollectTemplateContextDto contextDto) {
        Sets.SetView needUpdateDynamicKeys;
        Sets.SetView needAddDynamicKeys;
        String parentCode = entity.getCode();
        Map<String, BaseActivityItemVo> dbBasicItems = this.findByParentCode(parentCode);
        Validate.notEmpty(dbBasicItems, (String)"\u6839\u636e\u6d3b\u52a8\u5b57\u6bb5\u91c7\u96c6\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{parentCode});
        HashSet dbDynamicKeys = Sets.newHashSet(dbBasicItems.keySet());
        HashSet dynamicKeys = Sets.newHashSet(contextDto.getTargetActivity().getItems().keySet());
        ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo = (ActivitiesFieldsCollectTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contextDto.getTargetActivity(), ActivitiesFieldsCollectTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        Class calzz = this.dynamicFormServiceResolver.getDynamicFormClass(entity.getDynamicFormCode());
        Validate.notNull((Object)calzz, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u52a8\u6001\u6a21\u677f\u7c7b\u4fe1\u606f", (Object[])new Object[]{entity.getDynamicFormCode()});
        Sets.SetView needDeleteDynamicForms = Sets.difference((Set)dbDynamicKeys, (Set)dynamicKeys);
        if (!CollectionUtils.isEmpty((Collection)needDeleteDynamicForms)) {
            for (Object dynamicKey : needDeleteDynamicForms) {
                DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(entity.getCode(), entity.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
                Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                dynamicFormService.deleteDynamicDetails(parentCode);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(needAddDynamicKeys = Sets.difference((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
            for (String dynamicKey : needAddDynamicKeys) {
                DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(activitiesFieldsCollectTemplateVo.getCode(), activitiesFieldsCollectTemplateVo.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
                Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                this.transfer(activitiesFieldsCollectTemplateVo, calzz);
                dynamicFormService.createDynamicDetails((Object)activitiesFieldsCollectTemplateVo, activitiesFieldsCollectTemplateVo.getCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(needUpdateDynamicKeys = Sets.intersection((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
            for (String dynamicKey : needUpdateDynamicKeys) {
                DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(activitiesFieldsCollectTemplateVo.getCode(), activitiesFieldsCollectTemplateVo.getDynamicFormCode(), "items", ActivitiesFieldsCollectTemplateVo.class);
                Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                this.transfer(activitiesFieldsCollectTemplateVo, calzz);
                dynamicFormService.modifyDynamicDetails((Object)activitiesFieldsCollectTemplateVo, parentCode);
            }
        }
        return activitiesFieldsCollectTemplateVo;
    }

    private void transfer(ActivitiesFieldsCollectTemplateVo activitiesFieldsCollectTemplateVo, Class<?> calzz) {
        Map itemMap = activitiesFieldsCollectTemplateVo.getItems();
        String key = (String)itemMap.keySet().iterator().next();
        itemMap.put(activitiesFieldsCollectTemplateVo.getCode(), (BaseActivityItemVo)JSONObject.parseObject((String)JSONObject.toJSONString(itemMap.remove(key)), calzz));
    }
}

