/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.ordinary.service.internal;

import com.biz.crm.tpm.business.activities.ordinary.dto.OrdinaryActivityFilesDto;
import com.biz.crm.tpm.business.activities.ordinary.entity.OrdinaryActivityFiles;
import com.biz.crm.tpm.business.activities.ordinary.repository.OrdinaryActivityFilesRepository;
import com.biz.crm.tpm.business.activities.ordinary.service.OrdinaryActivityFilesService;
import com.biz.crm.tpm.business.activities.ordinary.vo.OrdinaryActivityFilesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrdinaryActivityFilesServiceImpl
implements OrdinaryActivityFilesService {
    @Autowired
    private OrdinaryActivityFilesRepository ordinaryActivityFilesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void save(List<OrdinaryActivityFilesDto> filesDtos, String activityCode) {
        Validate.notBlank((CharSequence)activityCode, (String)"\u666e\u901a\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(filesDtos)) {
            for (OrdinaryActivityFilesDto filesDto : filesDtos) {
                Validate.notBlank((CharSequence)filesDto.getFileCode(), (String)"\u666e\u901a\u6d3b\u52a8\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            filesDtos.forEach(e -> {
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setId(null);
                e.setActivityCode(activityCode);
            });
        }
        this.ordinaryActivityFilesRepository.deleteByActivityCodeAndTenantCode(activityCode, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(filesDtos)) {
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(filesDtos, OrdinaryActivityFilesDto.class, OrdinaryActivityFiles.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.ordinaryActivityFilesRepository.saveBatch(entities);
        }
    }

    @Override
    public List<OrdinaryActivityFilesVo> findByActivityCode(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return Lists.newArrayList();
        }
        List<OrdinaryActivityFiles> entities = this.ordinaryActivityFilesRepository.findByActivityCodeAndTenantCode(activityCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, OrdinaryActivityFiles.class, OrdinaryActivityFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }
}

