/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.ordinary.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.context.DynamicFormContext;
import com.biz.crm.common.form.sdk.context.DynamicFormContextHolder;
import com.biz.crm.tpm.business.activities.dynamic.template.service.DynamicFormServiceResolver;
import com.biz.crm.tpm.business.activities.ordinary.dto.OrdinaryActivityContextDto;
import com.biz.crm.tpm.business.activities.ordinary.dto.OrdinaryActivityDto;
import com.biz.crm.tpm.business.activities.ordinary.dto.OrdinaryActivityLogEventDto;
import com.biz.crm.tpm.business.activities.ordinary.entity.OrdinaryActivity;
import com.biz.crm.tpm.business.activities.ordinary.event.OrdinaryActivityLogEventListener;
import com.biz.crm.tpm.business.activities.ordinary.repository.OrdinaryActivityRepository;
import com.biz.crm.tpm.business.activities.ordinary.service.OrdinaryActivityFilesService;
import com.biz.crm.tpm.business.activities.ordinary.service.OrdinaryActivityService;
import com.biz.crm.tpm.business.activities.ordinary.vo.OrdinaryActivityFilesVo;
import com.biz.crm.tpm.business.activities.ordinary.vo.OrdinaryActivityVo;
import com.biz.crm.tpm.business.activities.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.BasicActivitiesInfoService;
import com.biz.crm.tpm.business.activities.sdk.strategy.close.ActivityItemsClosedStrategy;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BaseActivityItemVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BasicActivityItemVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_OrdinaryActivityServiceImpl")
public class OrdinaryActivityServiceImpl
implements OrdinaryActivityService,
BasicActivitiesInfoService {
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private OrdinaryActivityRepository ordinaryActivityRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicFormServiceResolver dynamicFormServiceResolver;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private List<ActivitiesEventListener> activitiesEventListeners;
    @Autowired
    private OrdinaryActivityFilesService ordinaryActivityFilesService;
    @Autowired(required=false)
    private List<ActivityItemsClosedStrategy> activitiesClosedStrategies;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    public Page<OrdinaryActivityVo> findByConditions(Pageable pageable, OrdinaryActivityDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new OrdinaryActivityDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.ordinaryActivityRepository.findByConditions(pageable, dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public OrdinaryActivityVo create(JSONObject json) {
        OrdinaryActivityDto dto = this.createValidation(json);
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        OrdinaryActivity entity = (OrdinaryActivity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, OrdinaryActivity.class, HashSet.class, ArrayList.class, new String[]{"activityFiles", "attachmentVos"}));
        entity.setStatus(this.analysisStatus(dto.getStartTime(), dto.getEndTime()).getCode());
        this.ordinaryActivityRepository.save((Object)entity);
        if (!CollectionUtils.isEmpty(dto.getActivityFiles())) {
            this.ordinaryActivityFilesService.save(dto.getActivityFiles(), entity.getCode());
        }
        String parentCode = entity.getCode();
        String dynamicKey = StringUtils.joinWith((String)":", (Object[])new Object[]{entity.getCostBudgetCode(), entity.getCostTypeCategoryCode()});
        DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
        Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
        OrdinaryActivityVo ordinaryActivityVo = (OrdinaryActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[]{"attachmentVos"}));
        try {
            OrdinaryActivityContextDto contextDto = this.buildActivityContextDto(null, dto, true);
            DynamicFormContext context = this.prepareDynamicFormContext(contextDto);
            dynamicFormService.createDynamicDetails((Object)ordinaryActivityVo, parentCode);
            this.validateTotalApplyAmount(context);
        }
        finally {
            DynamicFormContextHolder.clearContext();
        }
        if (dto.getProcessBusiness() != null) {
            OrdinaryActivityVo activityVo = this.findByCode(entity.getCode());
            for (Map.Entry entry : activityVo.getItems().entrySet()) {
                List basicItems = JSONArray.parseArray((String)JSONArray.toJSONString(entry.getValue()), BasicActivityItemVo.class);
                Validate.notEmpty((Collection)basicItems, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (BasicActivityItemVo basicItem : basicItems) {
                    this.costBudgetVoService.occupy(parentCode, basicItem.getItemCode(), basicItem.getCostBudgetCode(), basicItem.getApplyAmount(), basicItem.getRemark(), CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr());
                }
            }
            dto.setCode(entity.getCode());
            dto.setId(entity.getId());
            this.commitProcess(dto);
            this.ordinaryActivityRepository.saveOrUpdate((Object)entity);
        }
        OrdinaryActivityLogEventDto logEventDto = new OrdinaryActivityLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(ordinaryActivityVo);
        SerializableBiConsumer & Serializable onCreate = OrdinaryActivityLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, OrdinaryActivityLogEventListener.class, (SerializableBiConsumer)onCreate);
        return ordinaryActivityVo;
    }

    @Override
    @Transactional
    public OrdinaryActivityVo update(JSONObject json) {
        OrdinaryActivityDto dto = this.updateValidation(json);
        OrdinaryActivityVo sourceOrdinaryActivityVo = this.findByCode(dto.getCode());
        Validate.notNull((Object)((Object)sourceOrdinaryActivityVo), (String)"\u6839\u636e\u6d3b\u52a8\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{dto.getCode()});
        OrdinaryActivityContextDto contextDto = this.buildActivityContextDto(sourceOrdinaryActivityVo, dto, false);
        OrdinaryActivity dbOrdinaryActivity = (OrdinaryActivity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)sourceOrdinaryActivityVo, OrdinaryActivity.class, HashSet.class, ArrayList.class, new String[0]));
        OrdinaryActivityVo result = this.processDynamicFormsForUpdate(dbOrdinaryActivity, contextDto);
        dbOrdinaryActivity.setBudgetSubjectCode(dto.getBudgetSubjectCode());
        dbOrdinaryActivity.setBudgetSubjectName(dto.getBudgetSubjectName());
        dbOrdinaryActivity.setCostBudgetCode(dto.getCostBudgetCode());
        dbOrdinaryActivity.setCostTypeCategoryCode(dto.getCostTypeCategoryCode());
        dbOrdinaryActivity.setCostTypeCategoryName(dto.getCostTypeCategoryName());
        dbOrdinaryActivity.setEndTime(dto.getEndTime());
        dbOrdinaryActivity.setName(dto.getName());
        dbOrdinaryActivity.setRemark(dto.getRemark());
        dbOrdinaryActivity.setStartTime(dto.getStartTime());
        dbOrdinaryActivity.setTotalApplyAmount(dto.getTotalApplyAmount());
        dbOrdinaryActivity.setStatus(this.analysisStatus(dto.getStartTime(), dto.getEndTime()).getCode());
        this.ordinaryActivityRepository.saveOrUpdate((Object)dbOrdinaryActivity);
        if (!CollectionUtils.isEmpty(dto.getActivityFiles())) {
            this.ordinaryActivityFilesService.save(dto.getActivityFiles(), dbOrdinaryActivity.getCode());
        }
        OrdinaryActivityVo activityVo = this.findByCode(dbOrdinaryActivity.getCode());
        if (dto.getProcessBusiness() != null) {
            for (Map.Entry<String, List<BaseActivityItemVo>> item : activityVo.getItems().entrySet()) {
                List basicItems = JSONArray.parseArray((String)JSONArray.toJSONString(item.getValue()), BasicActivityItemVo.class);
                Validate.notEmpty((Collection)basicItems, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                basicItems.forEach(e -> this.costBudgetVoService.occupy(dbOrdinaryActivity.getCode(), e.getItemCode(), e.getCostBudgetCode(), e.getApplyAmount(), e.getRemark(), CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr()));
            }
            this.commitProcess(dto);
        }
        OrdinaryActivityVo ordinaryActivityVo = (OrdinaryActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbOrdinaryActivity, OrdinaryActivityVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        OrdinaryActivityLogEventDto logEventDto = new OrdinaryActivityLogEventDto();
        logEventDto.setOriginal(sourceOrdinaryActivityVo);
        logEventDto.setNewest(ordinaryActivityVo);
        SerializableBiConsumer & Serializable onUpdate = OrdinaryActivityLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, OrdinaryActivityLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return result;
    }

    @Override
    public OrdinaryActivityVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        OrdinaryActivity ordinaryActivity = this.ordinaryActivityRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        if (ordinaryActivity == null) {
            return null;
        }
        List<OrdinaryActivityFilesVo> ordinaryActivityFiles = this.ordinaryActivityFilesService.findByActivityCode(code);
        String dynamicKey = StringUtils.joinWith((String)":", (Object[])new Object[]{ordinaryActivity.getCostBudgetCode(), ordinaryActivity.getCostTypeCategoryCode()});
        DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
        OrdinaryActivityVo ordinaryActivityVo = (OrdinaryActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)ordinaryActivity, OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
        if (dynamicFormService == null) {
            return ordinaryActivityVo;
        }
        dynamicFormService.perfectDynamicDetails((Object)ordinaryActivityVo, ordinaryActivity.getCode());
        ordinaryActivityVo.setActivityFiles(ordinaryActivityFiles);
        CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(ordinaryActivity.getCostBudgetCode());
        if (costBudgetVo != null) {
            ordinaryActivityVo.setFinalBalance(costBudgetVo.getFinalBalance());
        }
        return ordinaryActivityVo;
    }

    @Override
    public List<OrdinaryActivityVo> findByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<OrdinaryActivity> ordinaryActivities = this.ordinaryActivityRepository.findByCodesAndTenantCode(codes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ordinaryActivities)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (OrdinaryActivity ordinaryActivity : ordinaryActivities) {
            String dynamicKey = StringUtils.joinWith((String)":", (Object[])new Object[]{ordinaryActivity.getCostBudgetCode(), ordinaryActivity.getCostTypeCategoryCode()});
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
            OrdinaryActivityVo ordinaryActivityVo = (OrdinaryActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)ordinaryActivity, OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
            if (dynamicFormService == null) continue;
            dynamicFormService.perfectDynamicDetails((Object)ordinaryActivityVo, ordinaryActivity.getCode());
            result.add(ordinaryActivityVo);
        }
        return result;
    }

    @Override
    public OrdinaryActivityVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        OrdinaryActivity ordinaryActivity = (OrdinaryActivity)((Object)this.ordinaryActivityRepository.getById((Serializable)((Object)id)));
        if (ordinaryActivity == null) {
            return null;
        }
        List<OrdinaryActivityFilesVo> ordinaryActivityFiles = this.ordinaryActivityFilesService.findByActivityCode(ordinaryActivity.getCode());
        String dynamicKey = StringUtils.joinWith((String)":", (Object[])new Object[]{ordinaryActivity.getCostBudgetCode(), ordinaryActivity.getCostTypeCategoryCode()});
        DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
        OrdinaryActivityVo ordinaryActivityVo = (OrdinaryActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)ordinaryActivity, OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
        if (dynamicFormService == null) {
            return ordinaryActivityVo;
        }
        dynamicFormService.perfectDynamicDetails((Object)ordinaryActivityVo, ordinaryActivity.getCode());
        ordinaryActivityVo.setActivityFiles(ordinaryActivityFiles);
        CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(ordinaryActivity.getCostBudgetCode());
        if (costBudgetVo != null) {
            ordinaryActivityVo.setFinalBalance(costBudgetVo.getFinalBalance());
        }
        return ordinaryActivityVo;
    }

    @Override
    public List<OrdinaryActivityVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List ordinaryActivities = this.ordinaryActivityRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)ordinaryActivities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)ordinaryActivities, OrdinaryActivity.class, OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    @Transactional
    public void delete(Set<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<OrdinaryActivityVo> ordinaryActivityVos = this.findByIds(ids);
        Validate.notEmpty(ordinaryActivityVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        List<String> auditCodes = ordinaryActivityVos.stream().map(OrdinaryActivityVo::getCode).collect(Collectors.toList());
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.findProcessBusinessMappingVo(auditCodes);
        if (CollectionUtils.isEmpty(processBusinessMappingVoList)) {
            Map<String, String> map = ordinaryActivityVos.stream().collect(Collectors.toMap(OrdinaryActivityVo::getCode, OrdinaryActivityVo::getName));
            processBusinessMappingVoList.forEach(item -> {
                throw new RuntimeException("\u3010" + (String)map.get(item.getBusinessNo()) + "\u3011\u3010" + item.getBusinessNo() + "\u3011\u4e0d\u662f\u5f85\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
            });
        }
        for (OrdinaryActivityVo ordinaryActivity : ordinaryActivityVos) {
            String parentCode = ordinaryActivity.getCode();
            String dynamicKey = StringUtils.joinWith((String)":", (Object[])new Object[]{ordinaryActivity.getCostBudgetCode(), ordinaryActivity.getCostTypeCategoryCode()});
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
            Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
            dynamicFormService.deleteDynamicDetails(parentCode);
            this.ordinaryActivityFilesService.save(null, parentCode);
        }
        this.ordinaryActivityRepository.deleteByIds(Lists.newArrayList(ids));
        SerializableBiConsumer & Serializable onDelete = OrdinaryActivityLogEventListener::onDelete;
        for (OrdinaryActivityVo ordinaryActivityVo : ordinaryActivityVos) {
            OrdinaryActivityLogEventDto logEventDto = new OrdinaryActivityLogEventDto();
            logEventDto.setOriginal(ordinaryActivityVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, OrdinaryActivityLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    private OrdinaryActivityDto createValidation(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u666e\u901a\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrdinaryActivityDto dto = (OrdinaryActivityDto)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), OrdinaryActivityDto.class));
        this.createValidation(dto);
        return dto;
    }

    private void createValidation(OrdinaryActivityDto dto) {
        Validate.notNull((Object)((Object)dto), (String)"\u666e\u901a\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        this.validateBase(dto);
        String ruleCode = StringUtils.join((Object[])new String[]{"HDBH", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.notEmpty((Collection)codeList, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u666e\u901a\u6d3b\u52a8\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        dto.setCode((String)codeList.get(0));
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)dto.getCode(), (String)pattern, (String)"\u7f16\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210\uff0c\u4e14\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6700\u7ec8\u7f16\u7801\u90fd\u5c06\u88ab\u5927\u5199", (Object[])new Object[0]);
        OrdinaryActivityVo ordinaryActivityVo = this.findByCode(dto.getCode());
        Validate.isTrue((ordinaryActivityVo == null ? 1 : 0) != 0, (String)"\u666e\u901a\u6d3b\u52a8\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
    }

    private void validateBase(OrdinaryActivityDto dto) {
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u666e\u901a\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((NumberUtils.compare((long)dto.getEndTime().getTime(), (long)dto.getStartTime().getTime()) > 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCostBudgetCode(), (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCostTypeCategoryCode(), (String)"\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCostTypeCategoryName(), (String)"\u9884\u7b97\u79d1\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCostTypeCategoryCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCostTypeCategoryName(), (String)"\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(dto.getItems(), (String)"\u666e\u901a\u6d3b\u52a8\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getTotalApplyAmount(), (String)"\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private OrdinaryActivityDto updateValidation(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u666e\u901a\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrdinaryActivityDto dto = (OrdinaryActivityDto)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), OrdinaryActivityDto.class));
        this.updateValidation(dto);
        return dto;
    }

    private void updateValidation(OrdinaryActivityDto dto) {
        Validate.notNull((Object)((Object)dto), (String)"\u666e\u901a\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u66f4\u65b0\u65f6\uff0c\u4e3b\u952eid\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        OrdinaryActivityVo ordinaryActivityVo = this.findById(dto.getId());
        Validate.notNull((Object)((Object)ordinaryActivityVo), (String)"\u6839\u636e\u63d0\u4f9b\u7684id\u4e3b\u952e\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)dto.getCode(), (CharSequence)ordinaryActivityVo.getCode()), (String)"\u4f20\u5165\u7684\u666e\u901a\u6d3b\u52a8\u7f16\u7801\u4e0e\u6570\u636e\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.validateBase(dto);
    }

    private OrdinaryActivityContextDto buildActivityContextDto(OrdinaryActivityVo sourceActivity, OrdinaryActivityDto targetActivity, boolean addOperate) {
        OrdinaryActivityContextDto contextDto = new OrdinaryActivityContextDto();
        Validate.notNull((Object)((Object)targetActivity), (String)"\u6700\u65b0\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        contextDto.setTargetActivity(targetActivity);
        if (!addOperate) {
            Validate.notNull((Object)((Object)sourceActivity), (String)"\u5386\u53f2\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            contextDto.setSourceActivity(sourceActivity);
        }
        return contextDto;
    }

    private DynamicFormContext prepareDynamicFormContext(OrdinaryActivityContextDto contextDto) {
        OrdinaryActivityDto targetActivity = contextDto.getTargetActivity();
        OrdinaryActivityVo sourceActivity = contextDto.getSourceActivity();
        Validate.notNull((Object)targetActivity.getTotalApplyAmount(), (String)"\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((targetActivity.getTotalApplyAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        DynamicFormContext context = DynamicFormContextHolder.getContext();
        context.put("targetTotalApplyAmount", (Object)targetActivity.getTotalApplyAmount());
        context.put("sumTotalApplyAmount", (Object)BigDecimal.ZERO);
        context.put("startTime", (Object)targetActivity.getStartTime());
        context.put("endTime", (Object)targetActivity.getEndTime());
        if (sourceActivity != null) {
            context.put("sourceTotalApplyAmount", (Object)sourceActivity.getTotalApplyAmount());
        }
        return context;
    }

    public String activityMark() {
        return "OrdinaryActivity";
    }

    public Map<String, List<BasicActivityItemVo>> findByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return Maps.newHashMap();
        }
        OrdinaryActivityVo ordinaryActivityVo = this.findByCode(parentCode);
        if (ordinaryActivityVo == null || CollectionUtils.isEmpty(ordinaryActivityVo.getItems())) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<BaseActivityItemVo>> entry : ordinaryActivityVo.getItems().entrySet()) {
            List<BaseActivityItemVo> itemVos = entry.getValue();
            List items = JSONArray.parseArray((String)JSONArray.toJSONString(itemVos), BasicActivityItemVo.class);
            result.put(entry.getKey(), items);
        }
        return result;
    }

    public ActivitiesVo findDetailsByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        OrdinaryActivityVo ordinaryActivityVo = this.findByCode(parentCode);
        if (ordinaryActivityVo == null) {
            return null;
        }
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)ordinaryActivityVo, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[]{"items"});
    }

    public List<ActivitiesVo> findDetailsByParentCodes(Set<String> parentCodes) {
        if (CollectionUtils.isEmpty(parentCodes)) {
            return Lists.newArrayList();
        }
        List<OrdinaryActivityVo> ordinaryActivityVos = this.findByCodes(parentCodes);
        if (CollectionUtils.isEmpty(ordinaryActivityVos)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(ordinaryActivityVos, OrdinaryActivityVo.class, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[]{"items"}));
    }

    public BasicActivityItemVo findByParentCodeAndItemCode(String parentCode, String itemCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        OrdinaryActivityVo ordinaryActivityVo = this.findByCode(parentCode);
        if (ordinaryActivityVo == null || CollectionUtils.isEmpty(ordinaryActivityVo.getItems())) {
            return null;
        }
        for (Map.Entry<String, List<BaseActivityItemVo>> entry : ordinaryActivityVo.getItems().entrySet()) {
            List<BaseActivityItemVo> itemVos = entry.getValue();
            List items = JSONArray.parseArray((String)JSONArray.toJSONString(itemVos), BasicActivityItemVo.class);
            for (BasicActivityItemVo item : items) {
                if (!StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)itemCode)) continue;
                return item;
            }
        }
        return null;
    }

    @Transactional
    public void onClosed(Map<String, Set<String>> codeMap) {
        Validate.notEmpty(codeMap, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u4f20\u5165\u7684\u6d3b\u52a8\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ActivitiesVo> activitiesVos = this.findDetailsByParentCodes(codeMap.keySet());
        if (CollectionUtils.isEmpty(activitiesVos)) {
            return;
        }
        Collection ordinaryActivityVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesVos, ActivitiesVo.class, OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (OrdinaryActivityVo ordinaryActivityVo : ordinaryActivityVos) {
            Set<String> waiteToCloseCodes = codeMap.get(ordinaryActivityVo.getCode());
            Map<String, List<BaseActivityItemVo>> itemMap = ordinaryActivityVo.getItems();
            for (Map.Entry<String, List<BaseActivityItemVo>> entry : itemMap.entrySet()) {
                String dynamicFormCode = entry.getValue().get(0).getDynamicFormCode();
                Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u5b9a\u989d\u6d3b\u52a8\u3010%s\u3011\u6d3b\u52a8\u660e\u7ec6\u5bf9\u5e94\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{ordinaryActivityVo.getCode()});
                Set itemCodes = entry.getValue().stream().map(BaseActivityItemVo::getItemCode).collect(Collectors.toSet());
                ActivityItemsClosedStrategy strategy = null;
                for (ActivityItemsClosedStrategy activityItemsClosedStrategy : this.activitiesClosedStrategies) {
                    if (!activityItemsClosedStrategy.dynamicFormCode().equals(dynamicFormCode)) continue;
                    strategy = activityItemsClosedStrategy;
                    break;
                }
                Validate.notNull(strategy, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u6839\u636e\u63d0\u4f9b\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u3010%s\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7b56\u7565\u4fe1\u606f", (Object[])new Object[]{dynamicFormCode});
                strategy.closed((Set)Sets.intersection(waiteToCloseCodes, itemCodes));
                boolean allClosed = strategy.allClosed(ordinaryActivityVo.getCode());
                this.ordinaryActivityRepository.updateForClose(ordinaryActivityVo.getCode(), allClosed);
            }
        }
    }

    @Transactional
    public void refreshActivityStatusForActivityTime() {
        List<OrdinaryActivity> activities = this.ordinaryActivityRepository.findByRefreshStatusTask();
        if (CollectionUtils.isEmpty(activities)) {
            return;
        }
        for (OrdinaryActivity ordinaryActivity : activities) {
            ActivityStatusEnum activityStatusEnum = this.analysisStatus(ordinaryActivity.getStartTime(), ordinaryActivity.getEndTime());
            ordinaryActivity.setStatus(activityStatusEnum.getCode());
        }
        this.ordinaryActivityRepository.saveOrUpdateBatch(activities);
    }

    @Override
    public boolean existByCostTypeCategoryCode(String costTypeCategoryCode) {
        if (StringUtils.isBlank((CharSequence)costTypeCategoryCode)) {
            return false;
        }
        int result = this.ordinaryActivityRepository.countByCostTypeCategoryCodeAndTenantCode(costTypeCategoryCode, TenantUtils.getTenantCode());
        return result > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrdinaryActivityVo processDynamicFormsForUpdate(OrdinaryActivity entity, OrdinaryActivityContextDto contextDto) {
        String parentCode = entity.getCode();
        Map<String, List<BasicActivityItemVo>> dbBasicItems = this.findByParentCode(parentCode);
        Validate.notEmpty(dbBasicItems, (String)"\u6839\u636e\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{parentCode});
        HashSet dbDynamicKeys = Sets.newHashSet(dbBasicItems.keySet());
        HashSet dynamicKeys = Sets.newHashSet(contextDto.getTargetActivity().getItems().keySet());
        OrdinaryActivityVo ordinaryActivityVo = (OrdinaryActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contextDto.getTargetActivity(), OrdinaryActivityVo.class, HashSet.class, ArrayList.class, new String[]{"attachmentVos", "shareInfos"}));
        try {
            Sets.SetView needUpdateDynamicKeys;
            Sets.SetView needAddDynamicKeys;
            DynamicFormContext context = this.prepareDynamicFormContext(contextDto);
            Sets.SetView needDeleteDynamicForms = Sets.difference((Set)dbDynamicKeys, (Set)dynamicKeys);
            if (!CollectionUtils.isEmpty((Collection)needDeleteDynamicForms)) {
                for (Object dynamicKey : needDeleteDynamicForms) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService((String)dynamicKey, "items", OrdinaryActivityVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.deleteDynamicDetails(parentCode);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(needAddDynamicKeys = Sets.difference((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
                for (String dynamicKey : needAddDynamicKeys) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.createDynamicDetails((Object)ordinaryActivityVo, parentCode);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(needUpdateDynamicKeys = Sets.intersection((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
                for (String dynamicKey : needUpdateDynamicKeys) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.modifyDynamicDetails((Object)ordinaryActivityVo, parentCode);
                }
            }
            this.validateTotalApplyAmount(context);
        }
        finally {
            DynamicFormContextHolder.clearContext();
        }
        return ordinaryActivityVo;
    }

    private void validateTotalApplyAmount(DynamicFormContext context) {
        if (context.exist("sumTotalApplyAmount") && context.exist("targetTotalApplyAmount")) {
            BigDecimal sumTotalApplyAmount;
            BigDecimal targetTotalApplyAmount = (BigDecimal)context.get("targetTotalApplyAmount");
            Validate.isTrue((targetTotalApplyAmount.compareTo(sumTotalApplyAmount = (BigDecimal)context.get("sumTotalApplyAmount")) == 0 ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u603b\u91d1\u989d\u4e0e\u7533\u8bf7\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.isTrue((targetTotalApplyAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        }
    }

    private ActivityStatusEnum analysisStatus(Date startTime, Date endTime) {
        Date now = new Date();
        if (NumberUtils.compare((long)now.getTime(), (long)startTime.getTime()) < 0) {
            return ActivityStatusEnum.UNEXECUTED;
        }
        if (NumberUtils.compare((long)now.getTime(), (long)endTime.getTime()) > 0) {
            return ActivityStatusEnum.ENDED;
        }
        return ActivityStatusEnum.EXECUTING;
    }

    private void commitProcess(OrdinaryActivityDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)((Object)dto)));
        processBusiness.setBusinessCode("ordinary_activity");
        this.processBusinessService.processStart(processBusiness);
    }

    private List<ProcessBusinessMappingVo> findProcessBusinessMappingVo(List<String> businessNos) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setBusinessNos(businessNos);
        processBusinessMappingDto.setBusinessCode("ordinary_activity");
        return this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
    }
}

