/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.ordinary.service.observer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.tpm.business.activities.dynamic.template.service.DynamicFormServiceResolver;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.DisplayActivityItemVo;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.MaterialActivityItemVo;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.QuotaActivityItemVo;
import com.biz.crm.tpm.business.activities.ordinary.service.OrdinaryActivityService;
import com.biz.crm.tpm.business.activities.ordinary.vo.OrdinaryActivityVo;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDto;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesRegisterService;
import com.biz.crm.tpm.business.activities.sdk.service.BasicActivitiesInfoService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BaseActivityItemVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BasicActivityItemVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingExecutorOprtType;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.BusinessStrategySettingExecutor;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrdinaryActivityProcessCallBackListener
implements ProcessCompleteListener {
    @Autowired(required=false)
    private OrdinaryActivityService ordinaryActivityService;
    @Autowired(required=false)
    private List<OperationStrategy> operationStraties;
    @Autowired(required=false)
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired
    private DynamicFormServiceResolver dynamicFormServiceResolver;
    @Autowired
    private ActivitiesRegisterService activitiesRegisterService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    @Qualifier(value="_OrdinaryActivityServiceImpl")
    private BasicActivitiesInfoService basicActivitiesInfoService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired(required=false)
    private List<BusinessStrategySettingExecutor> businessStrategySettingExecutors;
    @Autowired(required=false)
    private List<ActivitiesEventListener> activitiesEventListeners;

    public String getBusinessCode() {
        return "ordinary_activity";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("ordinary_activity")) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        OrdinaryActivityVo entity = this.ordinaryActivityService.findByCode(dto.getBusinessNo());
        Validate.notNull((Object)((Object)entity), (String)"\u6d3b\u52a8\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.PASS.getDictCode())) {
            Map<String, List<BaseActivityItemVo>> items = entity.getItems();
            Validate.notEmpty(items, (String)"\u6d3b\u52a8\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u5f53\u524d\u5b9e\u4f8b\u7f3a\u5931\u6d3b\u52a8\u660e\u7ec6", (Object[])new Object[0]);
            ArrayList res = new ArrayList();
            items.forEach((k, v) -> {
                if (!CollectionUtils.isEmpty((Collection)v)) {
                    List senSfaList;
                    List sendSfaCodes;
                    List codes;
                    List byCodes;
                    List voList;
                    BaseActivityItemVo baseActivityItemVo = (BaseActivityItemVo)v.get(0);
                    String parentCode = baseActivityItemVo.getParentCode();
                    String dynamicKey = baseActivityItemVo.getDynamicKey();
                    String dynamicFormCode = baseActivityItemVo.getDynamicFormCode();
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", OrdinaryActivityVo.class);
                    OperationStrategy selectedOperationStrategy = null;
                    for (OperationStrategy operationStrategy : this.operationStraties) {
                        if (!StringUtils.equals((CharSequence)operationStrategy.dynamicFormCode(), (CharSequence)dynamicFormCode)) continue;
                        selectedOperationStrategy = operationStrategy;
                    }
                    BusinessStrategySettingExecutor executor = BusinessStrategySettingExecutor.getExecutor(this.businessStrategySettingExecutors, (String)StrategySettingType.ACTIVITY.name());
                    Validate.notNull((Object)executor, (String)"\u6d3b\u52a8\u7533\u8bf7dynamicKey\u3010%s\u3011dynamicFormCode\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u5339\u914d\u5230\u76f8\u5e94\u7684\u7b56\u7565\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{dynamicKey, dynamicFormCode});
                    Class aClass = selectedOperationStrategy.dynamicFormClass();
                    if (!(aClass.getName() != DisplayActivityItemVo.class.getName() || CollectionUtils.isEmpty((Collection)(voList = (List)dynamicFormService.findDetailsByParentCodeAndDynamicFieldAndDynamicKey(parentCode, "items", dynamicKey, DisplayActivityItemVo.class))) || CollectionUtils.isEmpty((Collection)(byCodes = this.costTypeDetailVoService.findByCodes(codes = voList.stream().map(DisplayActivityItemVo::getCostTypeDetailCode).collect(Collectors.toList())))) || CollectionUtils.isEmpty(sendSfaCodes = byCodes.stream().filter(e -> executor.matchedOprtType(e.getSettingStrategies(), StrategySettingExecutorOprtType.PUSH_INFO.name(), (Object)true)).map(CostTypeDetailVo::getDetailCode).collect(Collectors.toList())))) {
                        senSfaList = voList.stream().filter(e -> sendSfaCodes.contains(e.getCostTypeDetailCode())).collect(Collectors.toList());
                        res.addAll(senSfaList);
                    }
                    if (!(aClass.getName() != MaterialActivityItemVo.class.getName() || CollectionUtils.isEmpty((Collection)(voList = (List)dynamicFormService.findDetailsByParentCodeAndDynamicFieldAndDynamicKey(parentCode, "items", dynamicKey, MaterialActivityItemVo.class))) || CollectionUtils.isEmpty((Collection)(byCodes = this.costTypeDetailVoService.findByCodes(codes = voList.stream().map(MaterialActivityItemVo::getCostTypeDetailCode).collect(Collectors.toList())))) || CollectionUtils.isEmpty(sendSfaCodes = byCodes.stream().filter(e -> executor.matchedOprtType(e.getSettingStrategies(), StrategySettingExecutorOprtType.PUSH_INFO.name(), (Object)true)).map(CostTypeDetailVo::getDetailCode).collect(Collectors.toList())))) {
                        senSfaList = voList.stream().filter(e -> sendSfaCodes.contains(e.getCostTypeDetailCode())).collect(Collectors.toList());
                        res.addAll(senSfaList);
                    }
                    if (!(aClass.getName() != QuotaActivityItemVo.class.getName() || CollectionUtils.isEmpty((Collection)(voList = (List)dynamicFormService.findDetailsByParentCodeAndDynamicFieldAndDynamicKey(parentCode, "items", dynamicKey, QuotaActivityItemVo.class))) || CollectionUtils.isEmpty((Collection)(byCodes = this.costTypeDetailVoService.findByCodes(codes = voList.stream().map(QuotaActivityItemVo::getCostTypeDetailCode).collect(Collectors.toList())))) || CollectionUtils.isEmpty(sendSfaCodes = byCodes.stream().filter(e -> executor.matchedOprtType(e.getSettingStrategies(), StrategySettingExecutorOprtType.PUSH_INFO.name(), (Object)true)).map(CostTypeDetailVo::getDetailCode).collect(Collectors.toList())))) {
                        senSfaList = voList.stream().filter(e -> sendSfaCodes.contains(e.getCostTypeDetailCode())).collect(Collectors.toList());
                        res.addAll(senSfaList);
                    }
                }
            });
            if (!CollectionUtils.isEmpty(res)) {
                // empty if block
            }
            ActivitiesDto activitiesDto = (ActivitiesDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesDto.class, HashSet.class, ArrayList.class, new String[0]);
            activitiesDto.setActivitiesCode(entity.getCode());
            activitiesDto.setActivitiesName(entity.getName());
            activitiesDto.setBeginTime(entity.getStartTime());
            activitiesDto.setActivityMark(this.basicActivitiesInfoService.activityMark());
            this.fillDetail(activitiesDto);
            this.activitiesRegisterService.register(activitiesDto);
        }
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.REJECT.getDictCode())) {
            this.backCostBudget(entity);
        }
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.RECOVER.getDictCode())) {
            this.backCostBudget(entity);
        }
        if (!CollectionUtils.isEmpty(this.activitiesEventListeners)) {
            ActivitiesVo vo = (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setActivitiesCode(entity.getCode());
            this.activitiesEventListeners.forEach(event -> event.onUpdateProcessStatus(vo, processStatus));
        }
    }

    private void fillDetail(ActivitiesDto activitiesDto) {
        OrdinaryActivityVo ordinaryActivityVo = this.ordinaryActivityService.findByCode(activitiesDto.getActivitiesCode());
        ActivitiesVo activitiesVo = (ActivitiesVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)ordinaryActivityVo)), ActivitiesVo.class);
        activitiesVo.setActivitiesCode(ordinaryActivityVo.getCode());
        activitiesVo.setActivitiesName(ordinaryActivityVo.getName());
        activitiesVo.setBeginTime(ordinaryActivityVo.getStartTime());
        Map detailMap = activitiesVo.getItems();
        Set entrySet = detailMap.entrySet();
        HashSet items = Sets.newHashSet();
        for (Map.Entry entry : entrySet) {
            items.addAll((Collection)entry.getValue());
        }
        ArrayList activitiesDetails = Lists.newArrayList();
        for (BasicActivityItemVo itemVo : items) {
            ActivitiesDetailDto detailDto = (ActivitiesDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)itemVo, ActivitiesDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            detailDto.setActivitiesCode(itemVo.getParentCode());
            detailDto.setActivitiesDetailCode(itemVo.getItemCode());
            detailDto.setActivitiesName(activitiesVo.getActivitiesName());
            detailDto.setCostBudgetCode(itemVo.getCostBudgetCode());
            detailDto.setId(null);
            activitiesDetails.add(detailDto);
        }
        activitiesDto.setActivitiesDetails((Set)Sets.newLinkedHashSet((Iterable)activitiesDetails));
    }

    private void backCostBudget(OrdinaryActivityVo ordinaryActivityVo) {
        for (String key : ordinaryActivityVo.getItems().keySet()) {
            List basicItems = JSONArray.parseArray((String)JSONArray.toJSONString(ordinaryActivityVo.getItems().get(key)), BasicActivityItemVo.class);
            Validate.notEmpty((Collection)basicItems, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            for (BasicActivityItemVo basicItem : basicItems) {
                this.costBudgetVoService.back(ordinaryActivityVo.getCode(), basicItem.getItemCode(), basicItem.getCostBudgetCode(), basicItem.getApplyAmount(), null, CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr());
            }
        }
    }
}

