/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.project.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activities.project.dto.ProjectActivityDto;
import com.biz.crm.tpm.business.activities.project.entity.ProjectActivity;
import com.biz.crm.tpm.business.activities.project.mapper.ProjectActivityMapper;
import com.biz.crm.tpm.business.activities.project.vo.ProjectActivityVo;
import com.biz.crm.tpm.business.activities.sdk.enums.ActivityStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ProjectActivityRepository
extends ServiceImpl<ProjectActivityMapper, ProjectActivity> {
    @Autowired
    private ProjectActivityMapper projectActivityMapper;

    public Page<ProjectActivityVo> findByConditions(Pageable pageable, ProjectActivityDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.projectActivityMapper.findByConditions((Page<ProjectActivityVo>)page, dto);
    }

    public ProjectActivity findByCodeAndTenantCode(String code, String tenantCode) {
        return (ProjectActivity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProjectActivity::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<ProjectActivity> findByCodesAndTenantCode(Set<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProjectActivity::getCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public int countByCodesAndTenantCode(Set<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProjectActivity::getCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
    }

    public void updateForClose(String code, Boolean isAllClosed) {
        ActivityStatusEnum status = isAllClosed != false ? ActivityStatusEnum.ALL_CLOSE : ActivityStatusEnum.PARTIAL_CLOSE;
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProjectActivity::getCode, (Object)code)).set(ProjectActivity::getStatus, (Object)status.getCode())).update();
    }

    public List<ProjectActivity> findByRefreshStatusTask() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().notIn(ProjectActivity::getStatus, (Collection)Sets.newHashSet((Object[])new String[]{ActivityStatusEnum.ALL_CLOSE.getCode(), ActivityStatusEnum.PARTIAL_CLOSE.getCode(), ActivityStatusEnum.ENDED.getCode()}))).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }
}

