/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.project.service.internal;

import com.biz.crm.tpm.business.activities.project.entity.ProjectActivityRelation;
import com.biz.crm.tpm.business.activities.project.repository.ProjectActivityRelationRepository;
import com.biz.crm.tpm.business.activities.project.service.ProjectActivityRelationService;
import com.biz.crm.tpm.business.activities.project.vo.ProjectActivityRelationVo;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProjectActivityRelationServiceImpl
implements ProjectActivityRelationService {
    @Autowired
    private ProjectActivityRelationRepository projectActivityRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;

    @Override
    public List<ProjectActivityRelationVo> findByActivityCode(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return Lists.newArrayList();
        }
        List<ProjectActivityRelation> relations = this.projectActivityRelationRepository.findByActivityCodeAndTenantCode(activityCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(relations)) {
            return Lists.newArrayList();
        }
        Collection relationVos = this.nebulaToolkitService.copyCollectionByWhiteList(relations, ProjectActivityRelation.class, ProjectActivityRelationVo.class, HashSet.class, ArrayList.class, new String[0]);
        Set costBudgetCodes = relationVos.stream().map(ProjectActivityRelationVo::getCostBudgetCode).collect(Collectors.toSet());
        List costBudgetVos = this.costBudgetVoService.findByCodes(costBudgetCodes);
        if (!CollectionUtils.isEmpty((Collection)costBudgetVos)) {
            for (ProjectActivityRelationVo relationVo : relationVos) {
                CostBudgetVo costBudgetVo = costBudgetVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)relationVo.getCostBudgetCode())).findFirst().orElse(null);
                if (costBudgetVo == null) continue;
                relationVo.setCostBudgetCode(costBudgetVo.getCode());
                relationVo.setBudgetSubjectCode(costBudgetVo.getBudgetSubjectCode());
                relationVo.setBudgetSubjectName(costBudgetVo.getBudgetSubjectName());
                relationVo.setChannelCode(costBudgetVo.getChannelCode());
                relationVo.setChannelName(costBudgetVo.getChannelName());
                relationVo.setCustomerCode(costBudgetVo.getCustomerCode());
                relationVo.setCustomerName(costBudgetVo.getCustomerName());
                relationVo.setFinalBalance(costBudgetVo.getFinalBalance());
                relationVo.setMonth(costBudgetVo.getMonth());
                relationVo.setOrgCode(costBudgetVo.getOrgCode());
                relationVo.setOrgName(costBudgetVo.getOrgName());
                relationVo.setProductCode(costBudgetVo.getProductCode());
                relationVo.setProductLevelCode(costBudgetVo.getProductLevelCode());
                relationVo.setProductLevelName(costBudgetVo.getProductLevelName());
                relationVo.setProductName(costBudgetVo.getProductName());
                relationVo.setQuarter(costBudgetVo.getQuarter());
                relationVo.setTerminalCode(costBudgetVo.getTerminalCode());
                relationVo.setTerminalName(costBudgetVo.getTerminalName());
                relationVo.setYear(costBudgetVo.getYear());
                relationVo.setType(costBudgetVo.getType());
            }
        }
        return Lists.newArrayList((Iterable)relationVos);
    }

    @Override
    @Transactional
    public void deleteByActivityCode(String activityCode) {
        Validate.notBlank((CharSequence)activityCode, (String)"\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.projectActivityRelationRepository.deleteByActivityCodeAndTenantCode(activityCode, TenantUtils.getTenantCode());
    }
}

