/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.scheme.dto.SchemeDto;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b9\u6848Vo\u529f\u80fd\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/activities/scheme"})
public class SchemeVoController {
    private static final Logger log = LoggerFactory.getLogger(SchemeVoController.class);
    @Autowired
    private SchemeVoService schemeVoService;

    @ApiOperation(value="\u7531\u4e8e\u521b\u5efa\u6216\u4fee\u6539\u5bfc\u81f4\u7684\u91cd\u590d\u63d0\u4ea4\u7684\u95ee\u9898\u3002\u5728\u521b\u5efa\u548c\u4fee\u6539\u524d\uff0c\u9700\u8981\u4f7f\u7528\u8be5\u65b9\u6cd5\u83b7\u5f97\u9884\u6388\u6743</br>")
    @PostMapping(value={"/preSave"})
    public Result<?> preSave() {
        try {
            String prefix = this.schemeVoService.preSave();
            return Result.ok((Object)prefix);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<SchemeVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="scheme", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") SchemeDto dto) {
        try {
            Page<SchemeVo> page = this.schemeVoService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<SchemeVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid", required=true) String id) {
        try {
            SchemeVo schemeVo = this.schemeVoService.findById(id);
            return Result.ok((Object)schemeVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<SchemeVo> findByCode(@ApiParam(name="code", value="\u7f16\u53f7", required=true) String code) {
        try {
            SchemeVo schemeVo = this.schemeVoService.findByCode(code);
            return Result.ok((Object)schemeVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<SchemeVo> create(@ApiParam(name="schemeVo", value="\u65b9\u6848") @RequestBody SchemeVo schemeVo) {
        try {
            SchemeVo result = this.schemeVoService.create(schemeVo);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<SchemeVo> update(@ApiParam(name="schemeVo", value="\u65b9\u6848") @RequestBody SchemeVo schemeVo) {
        try {
            SchemeVo result = this.schemeVoService.update(schemeVo);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.schemeVoService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

