/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.context.DynamicFormContext;
import com.biz.crm.common.form.sdk.context.DynamicFormContextHolder;
import com.biz.crm.tpm.business.activities.dynamic.template.service.DynamicFormServiceResolver;
import com.biz.crm.tpm.business.activities.scheme.dto.ActivitiesSchemeContextDto;
import com.biz.crm.tpm.business.activities.scheme.dto.ActivitiesSchemeDto;
import com.biz.crm.tpm.business.activities.scheme.dto.ActivitiesSchemeLogEventDto;
import com.biz.crm.tpm.business.activities.scheme.entity.ActivitiesScheme;
import com.biz.crm.tpm.business.activities.scheme.event.ActivitiesSchemeEventListener;
import com.biz.crm.tpm.business.activities.scheme.event.ActivitiesSchemeLogEventListener;
import com.biz.crm.tpm.business.activities.scheme.repository.ActivitiesSchemeRepository;
import com.biz.crm.tpm.business.activities.scheme.service.ActivitiesSchemeFilesService;
import com.biz.crm.tpm.business.activities.scheme.service.ActivitiesSchemeRelationService;
import com.biz.crm.tpm.business.activities.scheme.service.ActivitiesSchemeVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.ActivitiesSchemeFilesVo;
import com.biz.crm.tpm.business.activities.scheme.vo.ActivitiesSchemeRelationVo;
import com.biz.crm.tpm.business.activities.scheme.vo.ActivitiesSchemeVo;
import com.biz.crm.tpm.business.activities.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.BasicActivitiesInfoService;
import com.biz.crm.tpm.business.activities.sdk.strategy.close.ActivityItemsClosedStrategy;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BaseActivityItemVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BasicActivityItemVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activitiesSchemeVoService")
public class ActivitiesSchemeVoServiceImpl
implements ActivitiesSchemeVoService,
BasicActivitiesInfoService {
    @Autowired
    private ActivitiesSchemeRepository activitiesSchemeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<ActivitiesSchemeEventListener> activitiesSchemeEventListeners;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private DynamicFormServiceResolver dynamicFormServiceResolver;
    @Autowired
    private ActivitiesSchemeRelationService activitiesSchemeRelationService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private List<ActivitiesEventListener> activitiesEventListeners;
    @Autowired
    private ActivitiesSchemeFilesService activitiesSchemeFilesService;
    @Autowired(required=false)
    private List<ActivityItemsClosedStrategy> activitiesClosedStrategies;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    public Page<ActivitiesSchemeVo> findByConditions(Pageable pageable, ActivitiesSchemeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesSchemeDto();
        }
        return this.activitiesSchemeRepository.findByConditions(pageable, dto);
    }

    @Override
    public ActivitiesSchemeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivitiesScheme activitiesScheme = (ActivitiesScheme)((Object)this.activitiesSchemeRepository.getById((Serializable)((Object)id)));
        if (activitiesScheme == null) {
            return null;
        }
        ActivitiesSchemeVo activitiesSchemeVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesScheme, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List<ActivitiesSchemeRelationVo> activitiesSchemeRelationVos = this.activitiesSchemeRelationService.findByActivityCode(activitiesSchemeVo.getActivitiesCode());
        if (CollectionUtils.isEmpty(activitiesSchemeRelationVos)) {
            return activitiesSchemeVo;
        }
        activitiesSchemeVo.setRelations(activitiesSchemeRelationVos);
        Set dynamicKeys = activitiesSchemeRelationVos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
        for (String dynamicKey : dynamicKeys) {
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ActivitiesSchemeVo.class);
            if (dynamicFormService == null) continue;
            dynamicFormService.perfectDynamicDetails((Object)activitiesSchemeVo, activitiesSchemeVo.getActivitiesCode());
        }
        List<ActivitiesSchemeFilesVo> activitiesSchemeFilesVos = this.activitiesSchemeFilesService.findByActivitiesCode(activitiesScheme.getActivitiesCode());
        activitiesSchemeVo.setFiles(activitiesSchemeFilesVos);
        return activitiesSchemeVo;
    }

    @Override
    public ActivitiesSchemeVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ActivitiesScheme activitiesScheme = this.activitiesSchemeRepository.findByCode(code);
        if (activitiesScheme == null) {
            return null;
        }
        ActivitiesSchemeVo activitiesSchemeVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesScheme, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List<ActivitiesSchemeRelationVo> activitiesSchemeRelationVos = this.activitiesSchemeRelationService.findByActivityCode(activitiesSchemeVo.getActivitiesCode());
        if (CollectionUtils.isEmpty(activitiesSchemeRelationVos)) {
            return activitiesSchemeVo;
        }
        activitiesSchemeVo.setRelations(activitiesSchemeRelationVos);
        Set dynamicKeys = activitiesSchemeRelationVos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
        for (String dynamicKey : dynamicKeys) {
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ActivitiesSchemeVo.class);
            if (dynamicFormService == null) continue;
            dynamicFormService.perfectDynamicDetails((Object)activitiesSchemeVo, activitiesSchemeVo.getActivitiesCode());
        }
        List<ActivitiesSchemeFilesVo> activitiesSchemeFilesVos = this.activitiesSchemeFilesService.findByActivitiesCode(activitiesScheme.getActivitiesCode());
        activitiesSchemeVo.setFiles(activitiesSchemeFilesVos);
        return activitiesSchemeVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public ActivitiesSchemeVo create(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u65b0\u589e\u65b9\u6848\u6d3b\u52a8\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ActivitiesSchemeDto data = (ActivitiesSchemeDto)JSON.parseObject((String)JSON.toJSONString((Object)json), ActivitiesSchemeDto.class);
        ActivitiesSchemeVo activitiesSchemeVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)data, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[]{"items", "relations", "attachmentVos"}));
        activitiesSchemeVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activitiesSchemeVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        String code = (String)this.generateCodeService.generateCode("HDBH", 1).get(0);
        activitiesSchemeVo.setActivitiesCode(code);
        activitiesSchemeVo.setTenantCode(TenantUtils.getTenantCode());
        this.createValidate(activitiesSchemeVo);
        ActivitiesScheme activitiesScheme = (ActivitiesScheme)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesSchemeVo, ActivitiesScheme.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        activitiesSchemeVo.setId(activitiesScheme.getId());
        activitiesScheme.setStatus(this.analysisStatus(data.getBeginTime(), data.getEndTime()).getCode());
        this.activitiesSchemeRepository.saveOrUpdate((Object)activitiesScheme);
        activitiesSchemeVo.getRelations().forEach(vo -> {
            vo.setId(null);
            vo.setActivityCode(activitiesScheme.getActivitiesCode());
            vo.setTenantCode(TenantUtils.getTenantCode());
        });
        this.activitiesSchemeRelationService.saveBatch(activitiesSchemeVo.getRelations());
        String parentCode = activitiesScheme.getActivitiesCode();
        Set dynamicFormServices = this.dynamicFormServiceResolver.getDynamicFormServices(json, "items", ActivitiesSchemeVo.class);
        Validate.notEmpty((Collection)dynamicFormServices, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
        try {
            ActivitiesSchemeContextDto contextDto = this.buildActivityContextDto(null, data, true);
            DynamicFormContext dynamicFormContext = this.prepareDynamicFormContext(contextDto);
            for (DynamicFormService dynamicFormService : dynamicFormServices) {
                dynamicFormService.createDynamicDetails((Object)activitiesSchemeVo, parentCode);
            }
            this.validateTotalApplyAmount(dynamicFormContext);
        }
        finally {
            DynamicFormContextHolder.clearContext();
        }
        if (!CollectionUtils.isEmpty(data.getFiles())) {
            data.getFiles().forEach(item -> {
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setActivitiesCode(activitiesSchemeVo.getActivitiesCode());
            });
            List<ActivitiesSchemeFilesVo> activitiesSchemeFilesVos = this.activitiesSchemeFilesService.createBatch(data.getFiles());
            activitiesSchemeVo.setFiles(activitiesSchemeFilesVos);
        }
        activitiesSchemeVo.setId(activitiesScheme.getId());
        if (!CollectionUtils.isEmpty(this.activitiesSchemeEventListeners)) {
            for (ActivitiesSchemeEventListener activitiesSchemeEventListener : this.activitiesSchemeEventListeners) {
                activitiesSchemeEventListener.onCreated(activitiesSchemeVo);
            }
        }
        if (data.getProcessBusiness() != null) {
            ActivitiesSchemeVo activityVo = this.findByCode(activitiesScheme.getActivitiesCode());
            for (Map.Entry<String, List<BaseActivityItemVo>> entry : activityVo.getItems().entrySet()) {
                List basicItems = JSONArray.parseArray((String)JSONArray.toJSONString(entry.getValue()), BasicActivityItemVo.class);
                Validate.notEmpty((Collection)basicItems, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (BasicActivityItemVo basicItem : basicItems) {
                    this.costBudgetVoService.occupy(activitiesScheme.getActivitiesCode(), basicItem.getItemCode(), basicItem.getCostBudgetCode(), basicItem.getApplyAmount(), basicItem.getRemark(), CostBudgetItemSourceType.SCHEMA_ACTIVITY.getDescr());
                }
            }
            data.setId(activitiesScheme.getId());
            data.setActivitiesCode(activitiesScheme.getActivitiesCode());
            this.commitProcess(data);
        }
        ActivitiesSchemeLogEventDto logEventDto = new ActivitiesSchemeLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(activitiesSchemeVo);
        SerializableBiConsumer & Serializable intersect = ActivitiesSchemeLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesSchemeLogEventListener.class, (SerializableBiConsumer)intersect);
        return activitiesSchemeVo;
    }

    @Override
    @Transactional
    public ActivitiesSchemeVo update(JSONObject json) {
        List needAdds;
        Validate.notNull((Object)json, (String)"\u4fee\u6539\u65b9\u6848\u6d3b\u52a8\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ActivitiesSchemeDto data = (ActivitiesSchemeDto)JSON.parseObject((String)JSON.toJSONString((Object)json), ActivitiesSchemeDto.class);
        ActivitiesSchemeVo activitiesSchemeVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)data, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[]{"items", "relations", "attachmentVos"}));
        this.updateValidate(activitiesSchemeVo);
        ActivitiesScheme activitiesScheme = (ActivitiesScheme)((Object)this.activitiesSchemeRepository.getById((Serializable)((Object)activitiesSchemeVo.getId())));
        ActivitiesSchemeContextDto contextDto = this.buildActivityContextDto((ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesScheme, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[0])), data, false);
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.findProcessBusinessMappingVo(Lists.newArrayList((Object[])new String[]{activitiesScheme.getActivitiesCode()}));
        if (!CollectionUtils.isEmpty(processBusinessMappingVoList)) {
            ProcessBusinessMappingVo processBusinessMappingVo = processBusinessMappingVoList.get(0);
            String processStatus = processBusinessMappingVo.getProcessStatus();
            Validate.isTrue((ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus) || ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ? 1 : 0) != 0, (String)"\u53ea\u6709\u72b6\u6001\u4e3a\u3010\u6d41\u7a0b\u8ffd\u56de\u3001\u5ba1\u6279\u9a73\u56de\u3011\u6d3b\u52a8\u6570\u636e\u80fd\u4fee\u6539\uff0c\u3010%s\u3011\u6d3b\u52a8\u7533\u8bf7\u72b6\u6001\u4e3a\u3010%s\u3011", (Object[])new Object[]{activitiesScheme.getActivitiesName(), ProcessStatusEnum.getStatusNameByKey((String)processStatus)});
        }
        ActivitiesSchemeVo oldActivitiesSchemeVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesScheme, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        Validate.notNull((Object)((Object)activitiesScheme), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        activitiesScheme.setActivitiesName(activitiesSchemeVo.getActivitiesName());
        activitiesScheme.setSchemeCode(activitiesSchemeVo.getSchemeCode());
        activitiesScheme.setBeginTime(activitiesSchemeVo.getBeginTime());
        activitiesScheme.setEndTime(activitiesSchemeVo.getEndTime());
        activitiesScheme.setRemark(activitiesSchemeVo.getRemark());
        activitiesScheme.setTotalApplyAmount(activitiesSchemeVo.getTotalApplyAmount());
        activitiesScheme.setStatus(this.analysisStatus(data.getBeginTime(), data.getEndTime()).getCode());
        this.activitiesSchemeRepository.saveOrUpdate((Object)activitiesScheme);
        List<ActivitiesSchemeRelationVo> dbActivitiesSchemeRelationVo = this.activitiesSchemeRelationService.findByActivityCode(activitiesScheme.getActivitiesCode());
        Set currentIds = activitiesSchemeVo.getRelations().stream().map(UuidVo::getId).collect(Collectors.toSet());
        Set dbIds = dbActivitiesSchemeRelationVo.stream().map(UuidVo::getId).collect(Collectors.toSet());
        Sets.SetView needDeletes = Sets.difference(dbIds, currentIds);
        if (!CollectionUtils.isEmpty((Collection)needDeletes)) {
            this.activitiesSchemeRelationService.removeByIds((Collection<String>)needDeletes);
        }
        if (!CollectionUtils.isEmpty(needAdds = activitiesSchemeVo.getRelations().stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList()))) {
            for (ActivitiesSchemeRelationVo activitiesSchemeRelationVo : needAdds) {
                activitiesSchemeRelationVo.setId(null);
                activitiesSchemeRelationVo.setActivityCode(activitiesScheme.getActivitiesCode());
                activitiesSchemeRelationVo.setTenantCode(activitiesScheme.getTenantCode());
                this.activitiesSchemeRelationService.save(activitiesSchemeRelationVo);
            }
        }
        this.processDynamicFormsForUpdate(activitiesSchemeVo, contextDto);
        if (!CollectionUtils.isEmpty(data.getFiles())) {
            this.activitiesSchemeFilesService.deleteByActivitiesCode(data.getActivitiesCode());
            data.getFiles().forEach(item -> {
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setActivitiesCode(data.getActivitiesCode());
            });
            List<ActivitiesSchemeFilesVo> activitiesSchemeFilesVos = this.activitiesSchemeFilesService.createBatch(data.getFiles());
            activitiesSchemeVo.setFiles(activitiesSchemeFilesVos);
        }
        if (!CollectionUtils.isEmpty(this.activitiesSchemeEventListeners)) {
            for (ActivitiesSchemeEventListener activitiesSchemeEventListener : this.activitiesSchemeEventListeners) {
                activitiesSchemeEventListener.onUpdate(oldActivitiesSchemeVo, activitiesSchemeVo);
            }
        }
        if (data.getProcessBusiness() != null) {
            ActivitiesSchemeVo activityVo = this.findByCode(activitiesScheme.getActivitiesCode());
            for (Map.Entry<String, List<BaseActivityItemVo>> entry : activityVo.getItems().entrySet()) {
                List basicItems = JSONArray.parseArray((String)JSONArray.toJSONString(entry.getValue()), BasicActivityItemVo.class);
                Validate.notEmpty((Collection)basicItems, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (BasicActivityItemVo basicItem : basicItems) {
                    this.costBudgetVoService.occupy(activitiesScheme.getActivitiesCode(), basicItem.getItemCode(), basicItem.getCostBudgetCode(), basicItem.getApplyAmount(), basicItem.getRemark(), CostBudgetItemSourceType.SCHEMA_ACTIVITY.getDescr());
                }
            }
            data.setId(activitiesScheme.getId());
            data.setActivitiesCode(activitiesScheme.getActivitiesCode());
            this.commitProcess(data);
        }
        ActivitiesSchemeLogEventDto logEventDto = new ActivitiesSchemeLogEventDto();
        logEventDto.setOriginal(oldActivitiesSchemeVo);
        logEventDto.setNewest(activitiesSchemeVo);
        SerializableBiConsumer & Serializable intersect = ActivitiesSchemeLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesSchemeLogEventListener.class, (SerializableBiConsumer)intersect);
        return activitiesSchemeVo;
    }

    private void commitProcess(ActivitiesSchemeDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getActivitiesCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("SCHEME_ACTIVITIES");
        this.processBusinessService.processStart(processBusiness);
    }

    private List<ProcessBusinessMappingVo> findProcessBusinessMappingVo(List<String> businessNos) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setBusinessNos(businessNos);
        processBusinessMappingDto.setBusinessCode("SCHEME_ACTIVITIES");
        return this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivitiesScheme> activitiesSchemes = this.activitiesSchemeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(activitiesSchemes)) {
            return;
        }
        List<String> auditCodes = activitiesSchemes.stream().map(ActivitiesScheme::getActivitiesCode).collect(Collectors.toList());
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.findProcessBusinessMappingVo(auditCodes);
        if (CollectionUtils.isEmpty(processBusinessMappingVoList)) {
            Map<String, String> map = activitiesSchemes.stream().collect(Collectors.toMap(ActivitiesScheme::getActivitiesCode, ActivitiesScheme::getActivitiesName));
            processBusinessMappingVoList.forEach(item -> {
                throw new RuntimeException("\u53ea\u6709\u3010\u5f85\u63d0\u4ea4\u3011\u72b6\u6001\u6d3b\u52a8\u6570\u636e\u80fd\u5220\u9664\uff0c\u3010" + (String)map.get(item.getBusinessNo()) + "\u3011\u6d3b\u52a8\u72b6\u6001\u4e3a\u3010" + ProcessStatusEnum.getStatusNameByKey((String)item.getProcessStatus()) + "\u3011");
            });
        }
        Collection activitiesSchemeVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemes, ActivitiesScheme.class, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.activitiesSchemeRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.activitiesSchemeEventListeners)) {
            for (ActivitiesSchemeEventListener activitiesSchemeEventListener : this.activitiesSchemeEventListeners) {
                for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
                    activitiesSchemeEventListener.onDeleted(activitiesSchemeVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = ActivitiesSchemeLogEventListener::onDelete;
        for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
            ActivitiesSchemeLogEventDto logEventDto = new ActivitiesSchemeLogEventDto();
            logEventDto.setOriginal(activitiesSchemeVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesSchemeLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    public List<ActivitiesSchemeVo> findByEnableStatus(String enableStatus) {
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return Collections.emptyList();
        }
        List<ActivitiesScheme> activitiesScheme = this.activitiesSchemeRepository.findByEnableStatus(enableStatus);
        if (CollectionUtils.isEmpty(activitiesScheme)) {
            return Collections.emptyList();
        }
        Collection activitiesSchemes = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesScheme, ActivitiesScheme.class, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesSchemes);
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ActivitiesScheme> activitiesSchemes = this.activitiesSchemeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(activitiesSchemes)) {
            return;
        }
        Collection activitiesSchemeVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemes, ActivitiesScheme.class, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.activitiesSchemeRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
        if (!CollectionUtils.isEmpty(this.activitiesSchemeEventListeners)) {
            for (ActivitiesSchemeEventListener activitiesSchemeEventListener : this.activitiesSchemeEventListeners) {
                for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
                    activitiesSchemeEventListener.onEnable(activitiesSchemeVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onEnable = ActivitiesSchemeLogEventListener::onEnable;
        for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
            ActivitiesSchemeLogEventDto logEventDto = new ActivitiesSchemeLogEventDto();
            logEventDto.setOriginal(activitiesSchemeVo);
            ActivitiesSchemeVo newVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesSchemeVo, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[0]));
            newVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesSchemeLogEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ActivitiesScheme> activitiesSchemes = this.activitiesSchemeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(activitiesSchemes)) {
            return;
        }
        Collection activitiesSchemeVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemes, ActivitiesScheme.class, ActivitiesSchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.activitiesSchemeRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.activitiesSchemeEventListeners)) {
            for (ActivitiesSchemeEventListener activitiesSchemeEventListener : this.activitiesSchemeEventListeners) {
                for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
                    activitiesSchemeEventListener.onEnable(activitiesSchemeVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDisable = ActivitiesSchemeLogEventListener::onDisable;
        for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
            ActivitiesSchemeLogEventDto logEventDto = new ActivitiesSchemeLogEventDto();
            logEventDto.setOriginal(activitiesSchemeVo);
            ActivitiesSchemeVo newVo = (ActivitiesSchemeVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesSchemeVo, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[0]));
            newVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivitiesSchemeLogEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Override
    public int countByScheme(String schemeCode) {
        return this.activitiesSchemeRepository.countByScheme(schemeCode);
    }

    @Override
    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(ActivitiesSchemeVo activitiesSchemeVo) {
        block5: {
            String prefix = activitiesSchemeVo.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(ActivitiesSchemeVo activitiesSchemeVo) {
        Validate.notNull((Object)((Object)activitiesSchemeVo), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        activitiesSchemeVo.setId(null);
        this.validationPrefix(activitiesSchemeVo);
        Validate.notEmpty(activitiesSchemeVo.getRelations(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5! ", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeVo.getEnableStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u636e\u4e1a\u52a1\u72b6\u6001\uff08\u542f\u7528\u72b6\u6001\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeVo.getDelFlag(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u636e\u72b6\u6001\uff08\u5220\u9664\u72b6\u6001\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeVo.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeVo.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesSchemeVo.getBeginTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesSchemeVo.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeVo.getSchemeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesSchemeVo.getTotalApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(activitiesSchemeVo.getItems(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u660e\u7ec6\u8868\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (ActivitiesSchemeRelationVo relation : activitiesSchemeVo.getRelations()) {
            Validate.notBlank((CharSequence)relation.getCostBudgetCode(), (String)"\u5173\u8054\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryCode()) && !StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryName())) continue;
            Validate.notBlank((CharSequence)relation.getCostTypeCategoryCode(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)relation.getCostTypeCategoryName(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void updateValidate(ActivitiesSchemeVo activitiesSchemeVo) {
        Validate.notNull((Object)((Object)activitiesSchemeVo), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(activitiesSchemeVo);
        for (ActivitiesSchemeRelationVo relation : activitiesSchemeVo.getRelations()) {
            Validate.notBlank((CharSequence)relation.getCostBudgetCode(), (String)"\u5173\u8054\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryCode()) && !StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryName())) continue;
            Validate.notBlank((CharSequence)relation.getCostTypeCategoryCode(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)relation.getCostTypeCategoryName(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private ActivitiesSchemeContextDto buildActivityContextDto(ActivitiesSchemeVo sourceActivity, ActivitiesSchemeDto targetActivity, boolean addOperate) {
        ActivitiesSchemeContextDto contextDto = new ActivitiesSchemeContextDto();
        Validate.notNull((Object)targetActivity, (String)"\u6700\u65b0\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        contextDto.setTargetActivity(targetActivity);
        if (!addOperate) {
            Validate.notNull((Object)((Object)sourceActivity), (String)"\u5386\u53f2\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            contextDto.setSourceActivity(sourceActivity);
        }
        return contextDto;
    }

    private DynamicFormContext prepareDynamicFormContext(ActivitiesSchemeContextDto contextDto) {
        ActivitiesSchemeDto targetActivity = contextDto.getTargetActivity();
        ActivitiesSchemeVo sourceActivity = contextDto.getSourceActivity();
        Validate.notNull((Object)targetActivity.getTotalApplyAmount(), (String)"\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((targetActivity.getTotalApplyAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        DynamicFormContext context = DynamicFormContextHolder.getContext();
        context.put("targetTotalApplyAmount", (Object)targetActivity.getTotalApplyAmount());
        context.put("sumTotalApplyAmount", (Object)BigDecimal.ZERO);
        context.put("startTime", (Object)targetActivity.getBeginTime());
        context.put("endTime", (Object)targetActivity.getEndTime());
        if (sourceActivity != null) {
            context.put("sourceTotalApplyAmount", (Object)sourceActivity.getTotalApplyAmount());
        }
        return context;
    }

    @Transactional
    public void onClosed(Map<String, Set<String>> codeMap) {
        Validate.notEmpty(codeMap, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u4f20\u5165\u7684\u6d3b\u52a8\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ActivitiesVo> activitiesVos = this.findDetailsByParentCodes(codeMap.keySet());
        if (CollectionUtils.isEmpty(activitiesVos)) {
            return;
        }
        Collection activitiesSchemeVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesVos, ActivitiesVo.class, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
            Map<String, List<BaseActivityItemVo>> itemMap = activitiesSchemeVo.getItems();
            Set<String> waiteToCloseCodes = codeMap.get(activitiesSchemeVo.getActivitiesCode());
            HashMap closedStatus = Maps.newHashMap();
            for (Map.Entry<String, List<BaseActivityItemVo>> entry : itemMap.entrySet()) {
                String dynamicFormCode = entry.getValue().get(0).getDynamicFormCode();
                Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u65b9\u6848\u6d3b\u52a8\u3010%s\u3011\u6d3b\u52a8\u660e\u7ec6\u5bf9\u5e94\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{activitiesSchemeVo.getActivitiesCode()});
                Set itemCodes = entry.getValue().stream().map(BaseActivityItemVo::getItemCode).collect(Collectors.toSet());
                ActivityItemsClosedStrategy strategy = null;
                for (ActivityItemsClosedStrategy activityItemsClosedStrategy : this.activitiesClosedStrategies) {
                    if (!activityItemsClosedStrategy.dynamicFormCode().equals(dynamicFormCode)) continue;
                    strategy = activityItemsClosedStrategy;
                    break;
                }
                Validate.notNull(strategy, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u6839\u636e\u63d0\u4f9b\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u3010%s\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7b56\u7565\u4fe1\u606f", (Object[])new Object[]{dynamicFormCode});
                Sets.SetView intersections = Sets.intersection(waiteToCloseCodes, itemCodes);
                if (CollectionUtils.isEmpty((Collection)intersections)) {
                    closedStatus.put(entry.getKey(), strategy.allClosed(activitiesSchemeVo.getActivitiesCode()));
                    continue;
                }
                strategy.closed((Set)intersections);
                boolean allClosed = strategy.allClosed(activitiesSchemeVo.getActivitiesCode());
                closedStatus.put(entry.getKey(), allClosed);
            }
            boolean isAllClosed = closedStatus.values().stream().allMatch(e -> e != null && e != false);
            this.activitiesSchemeRepository.updateForClose(activitiesSchemeVo.getActivitiesCode(), isAllClosed);
        }
    }

    @Transactional
    public void refreshActivityStatusForActivityTime() {
        List<ActivitiesScheme> activities = this.activitiesSchemeRepository.findByRefreshStatusTask();
        if (CollectionUtils.isEmpty(activities)) {
            return;
        }
        for (ActivitiesScheme activitiesScheme : activities) {
            ActivityStatusEnum activityStatusEnum = this.analysisStatus(activitiesScheme.getBeginTime(), activitiesScheme.getEndTime());
            activitiesScheme.setStatus(activityStatusEnum.getCode());
        }
        this.activitiesSchemeRepository.saveOrUpdateBatch(activities);
    }

    public String activityMark() {
        return "SchemeActivity";
    }

    public Map<String, List<BasicActivityItemVo>> findByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return Maps.newHashMap();
        }
        ActivitiesSchemeVo activitiesSchemeVo = this.findByCode(parentCode);
        if (activitiesSchemeVo == null || CollectionUtils.isEmpty(activitiesSchemeVo.getItems())) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<BaseActivityItemVo>> entry : activitiesSchemeVo.getItems().entrySet()) {
            List<BaseActivityItemVo> itemVos = entry.getValue();
            List items = JSON.parseArray((String)JSON.toJSONString(itemVos), BasicActivityItemVo.class);
            result.put(entry.getKey(), items);
        }
        return result;
    }

    public ActivitiesVo findDetailsByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        ActivitiesSchemeVo activitiesSchemeVo = this.findByCode(parentCode);
        if (activitiesSchemeVo == null) {
            return null;
        }
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesSchemeVo, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivitiesVo> findDetailsByParentCodes(Set<String> parentCodes) {
        if (CollectionUtils.isEmpty(parentCodes)) {
            return Lists.newArrayList();
        }
        List<ActivitiesScheme> activitiesSchemes = this.activitiesSchemeRepository.findByCodes(Lists.newArrayList(parentCodes));
        if (CollectionUtils.isEmpty(activitiesSchemes)) {
            return Lists.newArrayList();
        }
        List<ActivitiesSchemeRelationVo> relationVos = this.activitiesSchemeRelationService.findByActivityCodes(activitiesSchemes.stream().map(ActivitiesScheme::getActivitiesCode).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty(relationVos)) {
            return Lists.newArrayList();
        }
        Collection activitiesSchemeVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemes, ActivitiesScheme.class, ActivitiesSchemeVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivitiesSchemeVo activitiesSchemeVo : activitiesSchemeVos) {
            List<ActivitiesSchemeRelationVo> relations = relationVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getActivityCode(), (CharSequence)activitiesSchemeVo.getActivitiesCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(relations)) continue;
            activitiesSchemeVo.setRelations(relations);
            Set dynamicKeys = relations.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
            for (String dynamicKey : dynamicKeys) {
                DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ActivitiesSchemeVo.class);
                if (dynamicFormService == null) continue;
                dynamicFormService.perfectDynamicDetails((Object)activitiesSchemeVo, activitiesSchemeVo.getActivitiesCode());
            }
        }
        Collection activitiesVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)activitiesSchemeVos, ActivitiesSchemeVo.class, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesVos);
    }

    public BasicActivityItemVo findByParentCodeAndItemCode(String parentCode, String itemCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        ActivitiesSchemeVo activitiesSchemeVo = this.findByCode(parentCode);
        if (activitiesSchemeVo == null || CollectionUtils.isEmpty(activitiesSchemeVo.getItems())) {
            return null;
        }
        for (Map.Entry<String, List<BaseActivityItemVo>> entry : activitiesSchemeVo.getItems().entrySet()) {
            List<BaseActivityItemVo> itemVos = entry.getValue();
            List items = JSON.parseArray((String)JSON.toJSONString(itemVos), BasicActivityItemVo.class);
            for (BasicActivityItemVo item : items) {
                if (!StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)itemCode)) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivitiesSchemeVo processDynamicFormsForUpdate(ActivitiesSchemeVo activitiesSchemeVo, ActivitiesSchemeContextDto contextDto) {
        String parentCode = activitiesSchemeVo.getActivitiesCode();
        Map<String, List<BasicActivityItemVo>> dbBasicItems = this.findByParentCode(parentCode);
        Validate.notEmpty(dbBasicItems, (String)"\u6839\u636e\u65b9\u6848\u6d3b\u52a8\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{parentCode});
        HashSet dbDynamicKeys = Sets.newHashSet(dbBasicItems.keySet());
        HashSet dynamicKeys = Sets.newHashSet(contextDto.getTargetActivity().getItems().keySet());
        try {
            Sets.SetView needUpdateDynamicKeys;
            Sets.SetView needAddDynamicKeys;
            DynamicFormContext context = this.prepareDynamicFormContext(contextDto);
            Sets.SetView needDeleteDynamicForms = Sets.difference((Set)dbDynamicKeys, (Set)dynamicKeys);
            if (!CollectionUtils.isEmpty((Collection)needDeleteDynamicForms)) {
                for (Object dynamicKey : needDeleteDynamicForms) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService((String)dynamicKey, "items", ActivitiesSchemeVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.deleteDynamicDetails(parentCode);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(needAddDynamicKeys = Sets.difference((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
                for (String dynamicKey : needAddDynamicKeys) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ActivitiesSchemeVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.createDynamicDetails((Object)activitiesSchemeVo, parentCode);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(needUpdateDynamicKeys = Sets.intersection((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
                for (String dynamicKey : needUpdateDynamicKeys) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ActivitiesSchemeVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.modifyDynamicDetails((Object)activitiesSchemeVo, parentCode);
                }
            }
            this.validateTotalApplyAmount(context);
        }
        finally {
            DynamicFormContextHolder.clearContext();
        }
        return activitiesSchemeVo;
    }

    private void validateTotalApplyAmount(DynamicFormContext context) {
        if (context.exist("sumTotalApplyAmount") && context.exist("targetTotalApplyAmount")) {
            BigDecimal sumTotalApplyAmount;
            BigDecimal targetTotalApplyAmount = (BigDecimal)context.get("targetTotalApplyAmount");
            Validate.isTrue((targetTotalApplyAmount.compareTo(sumTotalApplyAmount = (BigDecimal)context.get("sumTotalApplyAmount")) == 0 ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u603b\u91d1\u989d\u4e0e\u7533\u8bf7\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.isTrue((targetTotalApplyAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        }
    }

    private ActivityStatusEnum analysisStatus(Date startTime, Date endTime) {
        Date now = new Date();
        if (NumberUtils.compare((long)now.getTime(), (long)startTime.getTime()) < 0) {
            return ActivityStatusEnum.UNEXECUTED;
        }
        if (NumberUtils.compare((long)now.getTime(), (long)endTime.getTime()) > 0) {
            return ActivityStatusEnum.ENDED;
        }
        return ActivityStatusEnum.EXECUTING;
    }
}

