/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.biz.crm.tpm.business.activities.scheme.entity.SchemeCostBudget;
import com.biz.crm.tpm.business.activities.scheme.repository.SchemeCostBudgetRepository;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeCostBudgetVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeCostBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeCostBudgetVoService")
public class SchemeCostBudgetVoServiceImpl
implements SchemeCostBudgetVoService {
    @Autowired
    private SchemeCostBudgetRepository schemeCostBudgetRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Set<SchemeCostBudgetVo> findBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return Collections.emptySet();
        }
        List<SchemeCostBudget> schemeCostBudgets = this.schemeCostBudgetRepository.findBySchemeCode(schemeCode);
        if (schemeCostBudgets == null) {
            return Collections.emptySet();
        }
        Collection schemeFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeCostBudgets, SchemeCostBudget.class, SchemeCostBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)schemeFilesVos);
    }

    @Override
    @Transactional
    public SchemeCostBudgetVo create(SchemeCostBudgetVo schemeCostBudgetVo) {
        this.createValidate(schemeCostBudgetVo);
        SchemeCostBudget schemeCostBudget = (SchemeCostBudget)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)schemeCostBudgetVo, SchemeCostBudget.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        schemeCostBudget.setTenantCode(TenantUtils.getTenantCode());
        this.schemeCostBudgetRepository.saveOrUpdate((Object)schemeCostBudget);
        return schemeCostBudgetVo;
    }

    @Override
    @Transactional
    public void deleteBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return;
        }
        this.schemeCostBudgetRepository.deleteBySchemeCode(schemeCode);
    }

    private void createValidate(SchemeCostBudgetVo schemeCostBudgetVo) {
        Validate.notNull((Object)schemeCostBudgetVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        schemeCostBudgetVo.setId(null);
        Validate.notBlank((CharSequence)schemeCostBudgetVo.getCostBudgetCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u9884\u7b97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeCostBudgetVo.getSchemeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

