/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.biz.crm.tpm.business.activities.scheme.entity.SchemeFiles;
import com.biz.crm.tpm.business.activities.scheme.repository.SchemeFilesRepository;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeFilesVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeFilesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="schemeFilesVoService")
public class SchemeFilesVoServiceImpl
implements SchemeFilesVoService {
    @Autowired
    private SchemeFilesRepository schemeFilesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Set<SchemeFilesVo> findBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return Collections.emptySet();
        }
        List<SchemeFiles> schemeFiles = this.schemeFilesRepository.findBySchemeCode(schemeCode);
        if (schemeFiles == null) {
            return Collections.emptySet();
        }
        Collection schemeFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeFiles, SchemeFiles.class, SchemeFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)schemeFilesVos);
    }

    @Override
    @Transactional
    public SchemeFilesVo create(SchemeFilesVo schemeFilesVo) {
        this.createValidate(schemeFilesVo);
        SchemeFiles schemeFiles = (SchemeFiles)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)schemeFilesVo, SchemeFiles.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        schemeFiles.setTenantCode(TenantUtils.getTenantCode());
        this.schemeFilesRepository.saveOrUpdate((Object)schemeFiles);
        return schemeFilesVo;
    }

    @Override
    @Transactional
    public Set<SchemeFilesVo> createBatch(Set<SchemeFilesVo> schemeFilesVos) {
        if (CollectionUtils.isEmpty(schemeFilesVos)) {
            return Collections.emptySet();
        }
        for (SchemeFilesVo schemeFilesVo : schemeFilesVos) {
            this.create(schemeFilesVo);
        }
        return schemeFilesVos;
    }

    @Override
    @Transactional
    public void deleteBySchemeCode(String schemeCode) {
        this.schemeFilesRepository.deleteBySchemeCode(schemeCode);
    }

    private void createValidate(SchemeFilesVo schemeFilesVo) {
        Validate.notNull((Object)((Object)schemeFilesVo), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        schemeFilesVo.setId(null);
        Validate.notBlank((CharSequence)schemeFilesVo.getSchemeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeFilesVo.getFileCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

