/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.feign.feign.UserVoFeign;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.tpm.business.activities.scheme.dto.SchemeDto;
import com.biz.crm.tpm.business.activities.scheme.dto.SchemeLogEventDto;
import com.biz.crm.tpm.business.activities.scheme.entity.Scheme;
import com.biz.crm.tpm.business.activities.scheme.event.SchemeEventListener;
import com.biz.crm.tpm.business.activities.scheme.event.SchemeLogEventListener;
import com.biz.crm.tpm.business.activities.scheme.repository.SchemeRepository;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeCostBudgetVoService;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeFilesVoService;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeProductVoService;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeRangeVoService;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeCostBudgetVo;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeFilesVo;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeProductVo;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeRangeVo;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeVo;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="schemeVoService")
public class SchemeVoServiceImpl
implements SchemeVoService {
    @Autowired
    private SchemeRepository schemeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<SchemeEventListener> schemeEventListeners;
    @Autowired
    private SchemeFilesVoService schemeFilesVoService;
    @Autowired
    private SchemeProductVoService schemeProductVoService;
    @Autowired
    private SchemeCostBudgetVoService schemeCostBudgetVoService;
    @Autowired
    private SchemeRangeVoService schemeRangeVoService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private UserVoFeign userVoFeign;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<SchemeVo> findByConditions(Pageable pageable, SchemeDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SchemeDto();
        }
        List selectedCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            selectedCodeList.add(dto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            dto.setSelectedCodeList(selectedCodeList);
        }
        if (dto.isSelect()) {
            Set<SchemeRangeVo> schemeRangeVos = this.schemeRangeVoService.findAll();
            List schemeOrgCodes = schemeRangeVos.stream().filter(item -> item.getRangeType() == 1).map(SchemeRangeVo::getRangeCode).distinct().collect(Collectors.toList());
            List schemeOrgTypes = schemeRangeVos.stream().filter(item -> item.getRangeType() == 2).map(SchemeRangeVo::getRangeCode).distinct().collect(Collectors.toList());
            UserIdentity loginDetails = this.loginUserService.getLoginUser();
            Result userVoOrgCodeResult = this.userVoFeign.findRelationByUserNameAndOrgCodesOrOrgTypes(loginDetails.getAccount(), schemeOrgCodes, schemeOrgTypes);
            UserVo userVo = (UserVo)userVoOrgCodeResult.getResult();
            if (userVo != null) {
                dto.setOrgCodes(userVo.getRelationOrgCodes());
                dto.setOrgTypes(userVo.getRelationOrgTypes());
            }
            dto.setSchemeEndTime(new Date());
        }
        return this.schemeRepository.findByConditions(pageable, dto);
    }

    @Override
    public SchemeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Scheme scheme = (Scheme)((Object)this.schemeRepository.getById((Serializable)((Object)id)));
        if (scheme == null) {
            return null;
        }
        SchemeVo schemeVo = (SchemeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scheme, SchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetails(schemeVo);
        return schemeVo;
    }

    @Override
    public SchemeVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        Scheme scheme = this.schemeRepository.findByCode(code);
        if (scheme == null) {
            return null;
        }
        SchemeVo schemeVo = (SchemeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scheme, SchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetails(schemeVo);
        return schemeVo;
    }

    private void fillDetails(SchemeVo schemeVo) {
        if (schemeVo == null) {
            return;
        }
        Set<SchemeFilesVo> schemeFilesVos = this.schemeFilesVoService.findBySchemeCode(schemeVo.getSchemeCode());
        if (!CollectionUtils.isEmpty(schemeFilesVos)) {
            schemeVo.setSchemeFilesVos(schemeFilesVos);
        }
        Set<SchemeProductVo> schemeProductVos = this.schemeProductVoService.findBySchemeCode(schemeVo.getSchemeCode());
        schemeVo.setSchemeProductVos(schemeProductVos);
        Set<SchemeCostBudgetVo> schemeCostBudgetVos = this.schemeCostBudgetVoService.findBySchemeCode(schemeVo.getSchemeCode());
        LinkedHashSet costBudgetVos = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty(schemeCostBudgetVos)) {
            schemeCostBudgetVos.forEach(item -> {
                CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(item.getCostBudgetCode());
                if (Objects.nonNull(costBudgetVo)) {
                    costBudgetVos.add(costBudgetVo);
                }
            });
        }
        schemeVo.setSchemeCostBudgetVos(costBudgetVos);
        Set<SchemeRangeVo> schemeRangeVos = this.schemeRangeVoService.findBySchemeCode(schemeVo.getSchemeCode());
        schemeVo.setSchemeRangeVos(schemeRangeVos);
    }

    @Override
    @Transactional
    public SchemeVo create(SchemeVo schemeVo) {
        schemeVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.createValidate(schemeVo);
        String code = (String)this.generateCodeService.generateCode("R", 1).get(0);
        schemeVo.setSchemeCode(code);
        Scheme scheme = (Scheme)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)schemeVo, Scheme.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        scheme.setTenantCode(TenantUtils.getTenantCode());
        this.schemeRepository.saveOrUpdate((Object)scheme);
        if (!CollectionUtils.isEmpty(schemeVo.getSchemeFilesVos())) {
            for (SchemeFilesVo schemeFilesVo : schemeVo.getSchemeFilesVos()) {
                schemeFilesVo.setId(null);
                schemeFilesVo.setSchemeCode(scheme.getSchemeCode());
                schemeFilesVo.setTenantCode(TenantUtils.getTenantCode());
                this.schemeFilesVoService.create(schemeFilesVo);
            }
        }
        for (SchemeProductVo schemeProductVo : schemeVo.getSchemeProductVos()) {
            schemeProductVo.setId(null);
            schemeProductVo.setSchemeCode(schemeVo.getSchemeCode());
            schemeProductVo.setTenantCode(TenantUtils.getTenantCode());
            this.schemeProductVoService.create(schemeProductVo);
        }
        for (CostBudgetVo costBudgetVo : schemeVo.getSchemeCostBudgetVos()) {
            SchemeCostBudgetVo schemeCostBudgetVo = new SchemeCostBudgetVo();
            schemeCostBudgetVo.setId(null);
            schemeCostBudgetVo.setCostBudgetCode(costBudgetVo.getCode());
            schemeCostBudgetVo.setSchemeCode(schemeVo.getSchemeCode());
            schemeCostBudgetVo.setTenantCode(TenantUtils.getTenantCode());
            this.schemeCostBudgetVoService.create(schemeCostBudgetVo);
        }
        for (SchemeRangeVo schemeRangeVo : schemeVo.getSchemeRangeVos()) {
            schemeRangeVo.setId(null);
            schemeRangeVo.setSchemeCode(schemeVo.getSchemeCode());
            schemeRangeVo.setTenantCode(TenantUtils.getTenantCode());
            this.schemeRangeVoService.create(schemeRangeVo);
        }
        schemeVo.setId(scheme.getId());
        if (!CollectionUtils.isEmpty(this.schemeEventListeners)) {
            for (SchemeEventListener schemeEventListener : this.schemeEventListeners) {
                schemeEventListener.onCreated(schemeVo);
            }
        }
        SchemeLogEventDto logEventDto = new SchemeLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(schemeVo);
        SerializableBiConsumer & Serializable onCreate = SchemeLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SchemeLogEventListener.class, (SerializableBiConsumer)onCreate);
        return schemeVo;
    }

    @Override
    @Transactional
    public SchemeVo update(SchemeVo schemeVo) {
        this.updateValidate(schemeVo);
        Scheme scheme = (Scheme)((Object)this.schemeRepository.getById((Serializable)((Object)schemeVo.getId())));
        SchemeVo oldSchemeVo = (SchemeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scheme, SchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)scheme), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        scheme.setSchemeName(schemeVo.getSchemeName());
        scheme.setSchemeType(schemeVo.getSchemeType());
        scheme.setSchemeBeginTime(schemeVo.getSchemeBeginTime());
        scheme.setSchemeEndTime(schemeVo.getSchemeEndTime());
        scheme.setSchemeDescription(schemeVo.getSchemeDescription());
        scheme.setRemark(schemeVo.getRemark());
        this.schemeRepository.saveOrUpdate((Object)scheme);
        if (!CollectionUtils.isEmpty(schemeVo.getSchemeFilesVos())) {
            this.schemeFilesVoService.deleteBySchemeCode(scheme.getSchemeCode());
            for (SchemeFilesVo schemeFilesVo : schemeVo.getSchemeFilesVos()) {
                schemeFilesVo.setId(null);
                schemeFilesVo.setSchemeCode(scheme.getSchemeCode());
                schemeFilesVo.setTenantCode(TenantUtils.getTenantCode());
                this.schemeFilesVoService.create(schemeFilesVo);
            }
        }
        this.schemeProductVoService.deleteBySchemeCode(scheme.getSchemeCode());
        for (SchemeProductVo schemeProductVo : schemeVo.getSchemeProductVos()) {
            schemeProductVo.setId(null);
            schemeProductVo.setSchemeCode(scheme.getSchemeCode());
            schemeProductVo.setTenantCode(TenantUtils.getTenantCode());
            this.schemeProductVoService.create(schemeProductVo);
        }
        this.schemeCostBudgetVoService.deleteBySchemeCode(scheme.getSchemeCode());
        for (CostBudgetVo costBudgetVo : schemeVo.getSchemeCostBudgetVos()) {
            SchemeCostBudgetVo schemeCostBudgetVo = new SchemeCostBudgetVo();
            schemeCostBudgetVo.setId(null);
            schemeCostBudgetVo.setCostBudgetCode(costBudgetVo.getCode());
            schemeCostBudgetVo.setSchemeCode(schemeVo.getSchemeCode());
            schemeCostBudgetVo.setTenantCode(TenantUtils.getTenantCode());
            this.schemeCostBudgetVoService.create(schemeCostBudgetVo);
        }
        this.schemeRangeVoService.deleteBySchemeCode(scheme.getSchemeCode());
        for (SchemeRangeVo schemeRangeVo : schemeVo.getSchemeRangeVos()) {
            schemeRangeVo.setId(null);
            schemeRangeVo.setSchemeCode(schemeVo.getSchemeCode());
            schemeRangeVo.setTenantCode(TenantUtils.getTenantCode());
            this.schemeRangeVoService.create(schemeRangeVo);
        }
        if (!CollectionUtils.isEmpty(this.schemeEventListeners)) {
            for (SchemeEventListener schemeEventListener : this.schemeEventListeners) {
                schemeEventListener.onUpdate(oldSchemeVo, schemeVo);
            }
        }
        SchemeLogEventDto logEventDto = new SchemeLogEventDto();
        logEventDto.setOriginal(oldSchemeVo);
        logEventDto.setNewest(schemeVo);
        SerializableBiConsumer & Serializable onUpdate = SchemeLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SchemeLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return schemeVo;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Scheme> schemes = this.schemeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(schemes)) {
            return;
        }
        Collection schemeVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemes, Scheme.class, SchemeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.schemeRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.schemeEventListeners)) {
            for (SchemeEventListener schemeEventListener : this.schemeEventListeners) {
                for (SchemeVo schemeVo : schemeVos) {
                    schemeEventListener.onDeleted(schemeVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = SchemeLogEventListener::onDelete;
        for (SchemeVo schemeVo : schemeVos) {
            SchemeLogEventDto logEventDto = new SchemeLogEventDto();
            logEventDto.setOriginal(schemeVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SchemeLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    public boolean existsByCostBudget(String costBudgetCode) {
        return NumberUtils.compare((int)this.schemeRepository.countByCostBudgetCode(costBudgetCode), (int)0) > 0;
    }

    @Override
    public List<SchemeVo> findBySelect(String keyword) {
        UserIdentity loginDetails = this.loginUserService.getLoginUser();
        String account = loginDetails.getAccount();
        return null;
    }

    @Override
    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(SchemeVo schemeVo) {
        block5: {
            String prefix = schemeVo.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(SchemeVo schemeVo) {
        Validate.notNull((Object)schemeVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        schemeVo.setId(null);
        this.validationPrefix(schemeVo);
        Validate.notBlank((CharSequence)schemeVo.getDelFlag(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u636e\u72b6\u6001\uff08\u5220\u9664\u72b6\u6001\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeVo.getSchemeName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeVo.getSchemeType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)schemeVo.getSchemeBeginTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)schemeVo.getSchemeEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeVo.getSchemeDescription(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeVo.getSchemeStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(schemeVo.getSchemeProductVos(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(schemeVo.getSchemeCostBudgetVos(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u9884\u7b97\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(schemeVo.getSchemeRangeVos(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(SchemeVo schemeVo) {
        Validate.notNull((Object)schemeVo, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(schemeVo);
        Validate.notBlank((CharSequence)schemeVo.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeVo.getSchemeName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeVo.getSchemeType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)schemeVo.getSchemeBeginTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)schemeVo.getSchemeEndTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(schemeVo.getSchemeProductVos(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(schemeVo.getSchemeCostBudgetVos(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u9884\u7b97\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(schemeVo.getSchemeRangeVos(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65b9\u6848\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

