/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesShareDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d3b\u52a8\u4fe1\u606f\u8868\u529f\u80fd\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/activities/activities"})
public class ActivitiesController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiesController.class);
    @Autowired
    private ActivitiesService activitiesService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivitiesVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activities", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") ActivitiesDto dto) {
        try {
            Page page = this.activitiesService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ActivitiesVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid", required=true) String id) {
        try {
            ActivitiesVo activitiesVo = this.activitiesService.findById(id);
            return Result.ok((Object)activitiesVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<ActivitiesVo> findByActivitiesCode(@RequestParam(value="activitiesCode") @ApiParam(name="activitiesCode", value="\u7f16\u53f7", required=true) String activitiesCode) {
        try {
            ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(activitiesCode);
            return Result.ok((Object)activitiesVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e\u8be6\u60c5")
    @GetMapping(value={"findDetailsByActivitiesCode"})
    public Result<ActivitiesVo> findDetailsByActivitiesCode(@RequestParam(value="activitiesCode") @ApiParam(name="activitiesCode", value="\u7f16\u53f7", required=true) String activitiesCode) {
        try {
            ActivitiesVo activitiesVo = this.activitiesService.findDetailsByActivitiesCode(activitiesCode);
            return Result.ok((Object)activitiesVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u524d\u7aef\u4f20\u5165\u7684\u52a8\u6001\u8868\u5355\u4fe1\u606f\uff0c\u586b\u5145\u5206\u644a\u4fe1\u606f")
    @PostMapping(value={"shareForFeeDate"})
    public Result<List<?>> shareForFeeDate(@RequestBody ActivitiesShareDto dto) {
        try {
            List result = this.activitiesService.shareForFeeDate(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u6d3b\u52a8\u7f16\u7801\u96c6\u5408\uff0c\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"findDetailsByActivitiesCodes"})
    public Result<List<ActivitiesVo>> findDetailsByActivitiesCodes(@RequestParam(value="activitiesCodes") @ApiParam(name="activitiesCodes", value="\u4e3b\u6d3b\u52a8\u7f16\u7801") Set<String> activitiesCodes) {
        try {
            List result = this.activitiesService.findDetailsByActivitiesCodes(activitiesCodes);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u65f6\u95f4\u83b7\u53d6\u6d3b\u52a8\u7f16\u53f7")
    @GetMapping(value={"findCodeByTime"})
    public Result<List<String>> findCodeByTime(@RequestParam(value="time") @ApiParam(name="time", value="\u65f6\u95f4\uff08\u683c\u5f0f\u4e3a 1999-01\uff09") String time) {
        try {
            List result = this.activitiesService.findCodeByTime(time);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

