/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailRemoteDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f\u8868\u529f\u80fd\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/activities/activitiesDetail"})
public class ActivitiesDetailController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiesDetailController.class);
    @Autowired
    private ActivitiesDetailService activitiesDetailService;

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<List<ActivitiesDetailVo>> findByCode(@ApiParam(name="activitiesCode", value="\u6d3b\u52a8\u7f16\u53f7", required=true) String activitiesCode) {
        try {
            List activitiesDetailVos = this.activitiesDetailService.findByActivitiesCode(activitiesCode);
            return Result.ok((Object)activitiesDetailVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u660e\u7ec6\u5173\u95ed\u6d3b\u52a8")
    @PostMapping(value={"closed"})
    public Result<?> closed(@RequestBody @ApiParam(name="activitiesDetails", value="\u5173\u95ed\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f") List<ActivitiesDetailDto> activitiesDetailDtos) {
        try {
            this.activitiesDetailService.closed(activitiesDetailDtos);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6d3b\u52a8\u7f16\u53f7\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"findAllByActivitiesCodes"})
    public Result<List<ActivitiesDetailVo>> findAllByActivitiesCodes(@RequestParam(value="activitiesCodes") @ApiParam(name="activitiesCodes", value="\u7f16\u53f7", required=true) Set<String> activitiesCodes) {
        try {
            List detailVos = this.activitiesDetailService.findAllByActivitiesCodes(activitiesCodes);
            return Result.ok((Object)detailVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivitiesDetailVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activitiesDetail", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") ActivitiesDetailDto dto) {
        try {
            Page page = this.activitiesDetailService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6d3b\u52a8\u7f16\u53f7\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"findDetailByActivitiesDetailCode"})
    public Result<ActivitiesDetailVo> findDetailByActivitiesDetailCode(@RequestParam(value="activitiesDetailCode") @ApiParam(name="activitiesDetailCode", value="\u7f16\u53f7", required=true) String activitiesDetailCode) {
        try {
            ActivitiesDetailVo detailVs = this.activitiesDetailService.findDetailByActivitiesDetailCode(activitiesDetailCode);
            return Result.ok((Object)detailVs);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u76f8\u5173\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f\u4fdd\u5b58(SFA TO TPM)")
    @PostMapping(value={"createRemote"})
    public Result<ActivitiesDetailVo> createRemote(@RequestBody @ApiParam(name="dto", value="\u76f8\u5173\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f") ActivitiesDetailRemoteDto dto) {
        try {
            ActivitiesDetailVo result = this.activitiesDetailService.createRemote(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

