/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.local.entity.ActivitiesDetailCollect;
import com.biz.crm.tpm.business.activities.local.repository.ActivitiesDetailCollectRepository;
import com.biz.crm.tpm.business.activities.local.service.ActivitiesDetailCollectFilesService;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailCollectDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailCollectService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectFilesVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="activitiesDetailCollectService")
public class ActivitiesDetailCollectServiceImpl
implements ActivitiesDetailCollectService {
    @Autowired
    private ActivitiesDetailCollectRepository activitiesDetailCollectRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private ActivitiesDetailCollectFilesService activitiesDetailCollectFilesService;

    public Page<ActivitiesDetailCollectVo> findByConditions(Pageable pageable, ActivitiesDetailCollectDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDetailCollectDto();
        }
        return this.activitiesDetailCollectRepository.findByConditions(pageable, dto);
    }

    public ActivitiesDetailCollectVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivitiesDetailCollect activitiesDetailCollect = (ActivitiesDetailCollect)((Object)this.activitiesDetailCollectRepository.getById((Serializable)((Object)id)));
        if (activitiesDetailCollect == null) {
            return null;
        }
        ActivitiesDetailCollectVo activitiesDetailCollectVo = (ActivitiesDetailCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailCollect, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return activitiesDetailCollectVo;
    }

    public List<ActivitiesDetailCollectVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ActivitiesDetailCollect> activitiesDetailCollects = this.activitiesDetailCollectRepository.findByIds(ids);
        Collection activitiesDetailCollectVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailCollects, ActivitiesDetailCollect.class, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailCollectVos);
    }

    public List<ActivitiesDetailCollectVo> findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return null;
        }
        List<ActivitiesDetailCollect> activitiesDetailCollects = this.activitiesDetailCollectRepository.findByActivitiesCode(activitiesCode);
        if (CollectionUtils.isEmpty(activitiesDetailCollects)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailCollectVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailCollects, ActivitiesDetailCollect.class, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetailCollectVos.forEach(item -> this.fillDetail((ActivitiesDetailCollectVo)item));
        return Lists.newArrayList((Iterable)activitiesDetailCollectVos);
    }

    public List<ActivitiesDetailCollectVo> findByActivitiesCodes(Collection<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetailCollect> activitiesDetailCollects = this.activitiesDetailCollectRepository.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty(activitiesDetailCollects)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailCollectVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailCollects, ActivitiesDetailCollect.class, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetailCollectVos.forEach(item -> this.fillDetail((ActivitiesDetailCollectVo)item));
        return Lists.newArrayList((Iterable)activitiesDetailCollectVos);
    }

    public List<ActivitiesDetailCollectVo> findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetailCollect> activitiesDetailCollects = this.activitiesDetailCollectRepository.findByActivitiesDetailCode(activitiesDetailCode);
        if (CollectionUtils.isEmpty(activitiesDetailCollects)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailCollectVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailCollects, ActivitiesDetailCollect.class, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetailCollectVos.forEach(item -> this.fillDetail((ActivitiesDetailCollectVo)item));
        return Lists.newArrayList((Iterable)activitiesDetailCollectVos);
    }

    public List<ActivitiesDetailCollectVo> findByActivitiesDetailCodes(Collection<String> activitiesDetailCodes) {
        if (CollectionUtils.isEmpty(activitiesDetailCodes)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetailCollect> activitiesDetailCollects = this.activitiesDetailCollectRepository.findByActivitiesDetailCodes(activitiesDetailCodes);
        if (CollectionUtils.isEmpty(activitiesDetailCollects)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailCollectVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailCollects, ActivitiesDetailCollect.class, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetailCollectVos.forEach(item -> this.fillDetail((ActivitiesDetailCollectVo)item));
        return Lists.newArrayList((Iterable)activitiesDetailCollectVos);
    }

    @Transactional
    public ActivitiesDetailCollectVo create(ActivitiesDetailCollectDto activitiesDetailCollectDto) {
        this.createValidate(activitiesDetailCollectDto);
        activitiesDetailCollectDto.setCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)activitiesDetailCollectDto.getTenantCode())) {
            activitiesDetailCollectDto.setTenantCode(TenantUtils.getTenantCode());
        }
        ActivitiesDetailCollect activitiesDetailCollect = (ActivitiesDetailCollect)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailCollectDto, ActivitiesDetailCollect.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        String code = (String)this.generateCodeService.generateCode("CO", 1).get(0);
        activitiesDetailCollect.setCollectCode(code);
        activitiesDetailCollect.setTenantCode(TenantUtils.getTenantCode());
        this.activitiesDetailCollectRepository.saveOrUpdate((Object)activitiesDetailCollect);
        ActivitiesDetailCollectVo activitiesDetailCollectVo = (ActivitiesDetailCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailCollect, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)activitiesDetailCollectDto.getDetailCollectFiles())) {
            activitiesDetailCollectDto.getDetailCollectFiles().forEach(e -> e.setCollectCode(code));
            List<ActivitiesDetailCollectFilesVo> detailCollectFilesVos = this.activitiesDetailCollectFilesService.createBatch(activitiesDetailCollectDto.getDetailCollectFiles());
            activitiesDetailCollectVo.setDetailCollectFiles(detailCollectFilesVos);
        }
        activitiesDetailCollectVo.setId(activitiesDetailCollect.getId());
        return activitiesDetailCollectVo;
    }

    @Transactional
    public List<ActivitiesDetailCollectVo> createBatch(Collection<ActivitiesDetailCollectDto> activitiesDetailCollectDtos) {
        if (CollectionUtils.isEmpty(activitiesDetailCollectDtos)) {
            return Lists.newArrayList();
        }
        ArrayList activitiesDetailCollectVos = Lists.newArrayList();
        for (ActivitiesDetailCollectDto activitiesDetailCollectDto : activitiesDetailCollectDtos) {
            ActivitiesDetailCollectVo activitiesDetailCollectVo = this.create(activitiesDetailCollectDto);
            activitiesDetailCollectVos.add(activitiesDetailCollectVo);
        }
        return activitiesDetailCollectVos;
    }

    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivitiesDetailCollect> activitiesDetailCollects = this.activitiesDetailCollectRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(activitiesDetailCollects)) {
            return;
        }
        Collection activitiesDetailCollectVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailCollects, ActivitiesDetailCollect.class, ActivitiesDetailCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.activitiesDetailCollectRepository.removeByIds(ids);
    }

    private void createValidate(ActivitiesDetailCollectDto activitiesDetailCollectDto) {
        Validate.notNull((Object)activitiesDetailCollectDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((activitiesDetailCollectDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailCollectDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailCollectDto.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailCollectDto.getActivitiesDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailCollectDto.getBtNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u63d0\u4ea4\u6570\u636e\u6279\u6b21\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailCollectDto.getTerminalCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailCollectDto.getTerminalName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void fillDetail(ActivitiesDetailCollectVo activitiesDetailCollectVo) {
        List<ActivitiesDetailCollectFilesVo> detailCollectFilesVos = this.activitiesDetailCollectFilesService.findByCollectCode(activitiesDetailCollectVo.getCollectCode());
        activitiesDetailCollectVo.setDetailCollectFiles(detailCollectFilesVos);
    }
}

