/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activities.local.entity.ActivitiesDetailSerial;
import com.biz.crm.tpm.business.activities.local.repository.ActivitiesDetailSerialRepository;
import com.biz.crm.tpm.business.activities.local.service.ActivitiesDetailSerialService;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailSerialDto;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesDetailSerialEventListener;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="activitiesDetailSerialService")
public class ActivitiesDetailSerialServiceImpl
implements ActivitiesDetailSerialService {
    @Autowired
    private ActivitiesDetailSerialRepository activitiesDetailSerialRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ActivitiesDetailSerialEventListener> activitiesDetailSerialEventListeners;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<ActivitiesDetailSerialVo> findByConditions(Pageable pageable, ActivitiesDetailSerialDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDetailSerialDto();
        }
        return this.activitiesDetailSerialRepository.findByConditions(pageable, dto);
    }

    @Override
    public ActivitiesDetailSerialVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivitiesDetailSerial activitiesDetailSerial = (ActivitiesDetailSerial)((Object)this.activitiesDetailSerialRepository.getById((Serializable)((Object)id)));
        if (activitiesDetailSerial == null) {
            return null;
        }
        ActivitiesDetailSerialVo activitiesDetailSerialVo = (ActivitiesDetailSerialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailSerial, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return activitiesDetailSerialVo;
    }

    @Override
    public List<ActivitiesDetailSerialVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ActivitiesDetailSerial> activitiesDetailSerials = this.activitiesDetailSerialRepository.findByIds(ids);
        Collection activitiesDetailSerialVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailSerials, ActivitiesDetailSerial.class, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailSerialVos);
    }

    @Override
    public List<ActivitiesDetailSerialVo> findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetailSerial> activitiesDetailSerials = this.activitiesDetailSerialRepository.findByActivitiesCode(activitiesCode);
        if (CollectionUtils.isEmpty(activitiesDetailSerials)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailSerialVo = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailSerials, ActivitiesDetailSerial.class, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailSerialVo);
    }

    @Override
    public List<ActivitiesDetailSerialVo> findByActivitiesCodes(Collection<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetailSerial> activitiesDetailSerials = this.activitiesDetailSerialRepository.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty(activitiesDetailSerials)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailSerialVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailSerials, ActivitiesDetailSerial.class, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailSerialVos);
    }

    @Override
    public List<ActivitiesDetailSerialVo> findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        List<ActivitiesDetailSerial> activitiesDetailSerials = this.activitiesDetailSerialRepository.findByActivitiesDetailCode(activitiesDetailCode);
        if (CollectionUtils.isEmpty(activitiesDetailSerials)) {
            return null;
        }
        Collection activitiesDetailSerialVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailSerials, ActivitiesDetailSerial.class, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailSerialVos);
    }

    @Override
    public List<ActivitiesDetailSerialVo> findByActivitiesDetailCodes(Collection<String> activitiesDetailCodes) {
        if (CollectionUtils.isEmpty(activitiesDetailCodes)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetailSerial> activitiesDetailSerials = this.activitiesDetailSerialRepository.findByActivitiesDetailCodes(activitiesDetailCodes);
        if (CollectionUtils.isEmpty(activitiesDetailSerials)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailSerialVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailSerials, ActivitiesDetailSerial.class, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailSerialVos);
    }

    @Override
    @Transactional
    public ActivitiesDetailSerialVo create(ActivitiesDetailSerialDto activitiesDetailSerialDto) {
        this.createValidate(activitiesDetailSerialDto);
        ActivitiesDetailSerial activitiesDetailSerial = (ActivitiesDetailSerial)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailSerialDto, ActivitiesDetailSerial.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        activitiesDetailSerial.setTenantCode(TenantUtils.getTenantCode());
        this.activitiesDetailSerialRepository.saveOrUpdate((Object)activitiesDetailSerial);
        ActivitiesDetailSerialVo activitiesDetailSerialVo = (ActivitiesDetailSerialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailSerial, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetailSerialVo.setId(activitiesDetailSerial.getId());
        if (!CollectionUtils.isEmpty(this.activitiesDetailSerialEventListeners)) {
            for (ActivitiesDetailSerialEventListener activitiesDetailSerialEventListener : this.activitiesDetailSerialEventListeners) {
                activitiesDetailSerialEventListener.onCreated(activitiesDetailSerialVo);
            }
        }
        return activitiesDetailSerialVo;
    }

    @Override
    @Transactional
    public List<ActivitiesDetailSerialVo> createBatch(Collection<ActivitiesDetailSerialDto> activitiesDetailSerialDtos) {
        if (CollectionUtils.isEmpty(activitiesDetailSerialDtos)) {
            return Lists.newArrayList();
        }
        ArrayList activitiesDetailSerialVos = Lists.newArrayList();
        for (ActivitiesDetailSerialDto activitiesDetailSerialDto : activitiesDetailSerialDtos) {
            ActivitiesDetailSerialVo activitiesDetailSerialVo = this.create(activitiesDetailSerialDto);
            activitiesDetailSerialVos.add(activitiesDetailSerialVo);
        }
        return activitiesDetailSerialVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivitiesDetailSerial> activitiesDetailSerials = this.activitiesDetailSerialRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(activitiesDetailSerials)) {
            return;
        }
        Collection activitiesDetailSerialVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetailSerials, ActivitiesDetailSerial.class, ActivitiesDetailSerialVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.activitiesDetailSerialRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.activitiesDetailSerialEventListeners)) {
            for (ActivitiesDetailSerialEventListener activitiesDetailSerialEventListener : this.activitiesDetailSerialEventListeners) {
                for (ActivitiesDetailSerialVo activitiesDetailSerialVo : activitiesDetailSerialVos) {
                    activitiesDetailSerialEventListener.onDeleted(activitiesDetailSerialVo);
                }
            }
        }
    }

    @Override
    public BigDecimal findAmountByActivitiesDetailCode(String activitiesDetailCode) {
        return this.activitiesDetailSerialRepository.sumAmountByActivitiesCode(activitiesDetailCode);
    }

    private void createValidate(ActivitiesDetailSerialDto activitiesDetailSerialDto) {
        Validate.notNull((Object)activitiesDetailSerialDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((activitiesDetailSerialDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailSerialDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailSerialDto.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailSerialDto.getActivitiesDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailSerialDto.getSerialNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDetailSerialDto.getSerialPrice(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDetailSerialDto.getSerialTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailSerialDto.getBtNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u63d0\u4ea4\u6570\u636e\u6279\u6b21\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((activitiesDetailSerialDto.getSerialPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0!", (Object[])new Object[0]);
    }
}

