/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activities.local.entity.ActivitiesDetail;
import com.biz.crm.tpm.business.activities.local.repository.ActivitiesDetailRepository;
import com.biz.crm.tpm.business.activities.local.service.ActivitiesDetailSerialService;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailRemoteDto;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesDetailEventListener;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesDetailFilterEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailCollectService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesFieldsCollectTemplateService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.service.BasicActivitiesInfoService;
import com.biz.crm.tpm.business.activities.sdk.service.DynamicTemplateService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesFieldsCollectTemplateFeginVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesFieldsCollectTemplateVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.service.ApprovalCollectVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeCategoryVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activitiesDetailService")
public class ActivitiesDetailServiceImpl
implements ActivitiesDetailService {
    @Autowired
    private ActivitiesDetailRepository activitiesDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired(required=false)
    private List<ActivitiesDetailEventListener> activitiesDetailEventListeners;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ActivitiesDetailSerialService activitiesDetailSerialService;
    @Autowired
    private CostTypeCategoryVoService costTypeCategoryVoService;
    @Autowired
    private ApprovalCollectVoService approvalCollectVoService;
    @Autowired
    private ActivitiesDetailCollectService activitiesDetailCollectService;
    @Autowired
    private DynamicTemplateService dynamicTemplateService;
    @Autowired
    private ActivitiesFieldsCollectTemplateService activitiesFieldsCollectTemplateService;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired(required=false)
    private List<ActivitiesDetailFilterEventListener> activitiesDetailFilterEventListeners;

    public Page<ActivitiesDetailVo> findByConditions(Pageable pageable, ActivitiesDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDetailDto();
        }
        String terminalCode = dto.getTerminalCode();
        HashSet excludeActivitiesDetailCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(this.activitiesDetailFilterEventListeners)) {
            for (ActivitiesDetailFilterEventListener activitiesDetailFilterEventListener : this.activitiesDetailFilterEventListeners) {
                excludeActivitiesDetailCodes.addAll(activitiesDetailFilterEventListener.filterActivitiesDetailCode(dto));
            }
        }
        dto.setExcludeItemCodes((Set)excludeActivitiesDetailCodes);
        Page<ActivitiesDetailVo> page = this.activitiesDetailRepository.findByConditions(pageable, dto);
        if (page.getSize() > 0L) {
            List result = page.getRecords();
            result.forEach(item -> {
                List<ActivitiesDetailSerialVo> activitiesDetailSerialVos;
                ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(item.getActivitiesCode());
                item.setActivities(activitiesVo);
                if (StringUtils.isNotBlank((CharSequence)terminalCode) && !CollectionUtils.isEmpty(activitiesDetailSerialVos = this.activitiesDetailSerialService.findByActivitiesDetailCode(item.getActivitiesDetailCode()))) {
                    BigDecimal terminalAmount = activitiesDetailSerialVos.stream().filter(serial -> terminalCode.equals(serial.getTerminalCode())).map(ActivitiesDetailSerialVo::getSerialPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    item.setTerminalAmount(terminalAmount);
                }
                CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(item.getCostTypeDetailCode());
                item.setCostTypeDetailVo(costTypeDetailVo);
            });
        }
        return page;
    }

    public ActivitiesDetailVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivitiesDetail activitiesDetail = (ActivitiesDetail)((Object)this.activitiesDetailRepository.getById((Serializable)((Object)id)));
        if (activitiesDetail == null) {
            return null;
        }
        ActivitiesDetailVo activitiesDetailVo = (ActivitiesDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetail, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return activitiesDetailVo;
    }

    public List<ActivitiesDetailVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ActivitiesDetail> activitiesDetails = this.activitiesDetailRepository.findByIds(ids);
        Collection activitiesDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetails, ActivitiesDetail.class, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailVos);
    }

    public List<ActivitiesDetailVo> findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return Collections.emptyList();
        }
        List<ActivitiesDetail> activitiesDetails = this.activitiesDetailRepository.findByActivitiesCode(activitiesCode);
        if (CollectionUtils.isEmpty(activitiesDetails)) {
            return Collections.emptyList();
        }
        Collection activitiesDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetails, ActivitiesDetail.class, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesDetailVos);
    }

    public Map<String, List<ActivitiesDetailVo>> findByActivitiesCodes(Collection<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Maps.newHashMap();
        }
        List<ActivitiesDetail> activitiesDetails = this.activitiesDetailRepository.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty(activitiesDetails)) {
            return Maps.newHashMap();
        }
        Collection activitiesDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetails, ActivitiesDetail.class, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return activitiesDetailVos.stream().collect(Collectors.groupingBy(ActivitiesDetailVo::getActivitiesCode));
    }

    public List<ActivitiesDetailVo> findAllByActivitiesCodes(Collection<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Lists.newArrayList();
        }
        List<ActivitiesDetail> activitiesDetails = this.activitiesDetailRepository.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty(activitiesDetails)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetails, ActivitiesDetail.class, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public List<ActivitiesDetailVo> findByActivitiesDetailCodes(Collection<String> activitiesDetailCodes) {
        if (CollectionUtils.isEmpty(activitiesDetailCodes)) {
            return Lists.newArrayList();
        }
        List<ActivitiesDetail> activitiesDetails = this.activitiesDetailRepository.findByActivitiesDetailCodes(activitiesDetailCodes);
        if (CollectionUtils.isEmpty(activitiesDetails)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(activitiesDetails, ActivitiesDetail.class, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public ActivitiesDetailVo findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        ActivitiesDetail activitiesDetail = this.activitiesDetailRepository.findByActivitiesDetailCode(activitiesDetailCode);
        if (activitiesDetail == null) {
            return null;
        }
        ActivitiesDetailVo activitiesDetailVo = (ActivitiesDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetail, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return activitiesDetailVo;
    }

    public ActivitiesDetailVo findDetailByActivitiesDetailCode(String activitesDetailCode) {
        ActivitiesDetailVo activitiesDetailVo = this.findByActivitiesDetailCode(activitesDetailCode);
        this.fillDetail(activitiesDetailVo);
        return activitiesDetailVo;
    }

    @Transactional
    public ActivitiesDetailVo create(ActivitiesDetailDto activitiesDetailDto) {
        this.createValidate(activitiesDetailDto);
        ActivitiesDetail activitiesDetail = (ActivitiesDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetailDto, ActivitiesDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        activitiesDetail.setTenantCode(TenantUtils.getTenantCode());
        activitiesDetail.setIsClose(BooleanEnum.FALSE.getCapital());
        activitiesDetail.setTotalAmount(BigDecimal.ZERO);
        activitiesDetail.setIsExecute(BooleanEnum.FALSE.getCapital());
        if (StringUtils.isNotBlank((CharSequence)activitiesDetailDto.getIsFullAudit())) {
            activitiesDetail.setIsFullAudit(activitiesDetailDto.getIsFullAudit());
        } else {
            activitiesDetail.setIsFullAudit(BooleanEnum.FALSE.getCapital());
        }
        CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(activitiesDetailDto.getCostTypeDetailCode());
        Validate.notNull((Object)costTypeDetailVo, (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011\u5173\u8054\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{activitiesDetailDto.getActivitiesDetailCode(), activitiesDetailDto.getCostTypeCategoryCode()});
        activitiesDetail.setIsSendSfa(costTypeDetailVo.getIsSendSfa());
        this.activitiesDetailRepository.saveOrUpdate((Object)activitiesDetail);
        ActivitiesDetailVo activitiesDetailVo = (ActivitiesDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetail, ActivitiesDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetailVo.setId(activitiesDetail.getId());
        return activitiesDetailVo;
    }

    @Transactional
    public List<ActivitiesDetailVo> createBatch(Collection<ActivitiesDetailDto> activitiesDetailDtos) {
        if (CollectionUtils.isEmpty(activitiesDetailDtos)) {
            return Lists.newArrayList();
        }
        ArrayList activitiesDetailVos = Lists.newArrayList();
        for (ActivitiesDetailDto activitiesDetailDto : activitiesDetailDtos) {
            ActivitiesDetailVo activitiesDetailVo = this.create(activitiesDetailDto);
            activitiesDetailVos.add(activitiesDetailVo);
        }
        return activitiesDetailVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void closed(Collection<ActivitiesDetailDto> activitiesDetailDtos) {
        if (CollectionUtils.isEmpty(activitiesDetailDtos)) {
            return;
        }
        HashSet details = Sets.newHashSet();
        for (ActivitiesDetailDto activitiesDetailDto : activitiesDetailDtos) {
            ActivitiesDetail activitiesDetail = this.activitiesDetailRepository.findByActivitiesDetailCode(activitiesDetailDto.getActivitiesDetailCode());
            Validate.notNull((Object)((Object)activitiesDetail), (String)"\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u9519\u8bef\uff0c\u7f16\u53f7\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{activitiesDetailDto.getActivitiesDetailCode()});
            Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(activitiesDetail.getIsClose()) ? 1 : 0) != 0, (String)"\u8be5\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u5df2\u7ecf\u5173\u95ed\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{activitiesDetailDto.getActivitiesDetailCode()});
            activitiesDetail.setIsClose(BooleanEnum.TRUE.getCapital());
            this.activitiesDetailRepository.saveOrUpdate((Object)activitiesDetail);
            ActivitiesDetailDto detail = (ActivitiesDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDetail, ActivitiesDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            details.add(detail);
        }
        if (!CollectionUtils.isEmpty((Map)BasicActivitiesInfoService.ACTIVITY_SERVICE_MAPPING)) {
            Map codeMap = details.stream().collect(Collectors.groupingBy(ActivitiesDetailDto::getActivitiesCode, Collectors.mapping(ActivitiesDetailDto::getActivitiesDetailCode, Collectors.toSet())));
            Set activityMarks = BasicActivitiesInfoService.ACTIVITY_SERVICE_MAPPING.keySet();
            boolean hasLock = false;
            try {
                hasLock = this.redisMutexService.tryLock("GLOBAL_ACTIVITY_STATUS_REDIS_LOCK", TimeUnit.SECONDS, 10);
                Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                for (String activityMark : activityMarks) {
                    BasicActivitiesInfoService service = (BasicActivitiesInfoService)BasicActivitiesInfoService.ACTIVITY_SERVICE_MAPPING.get(activityMark);
                    service.onClosed(codeMap);
                }
            }
            finally {
                if (hasLock) {
                    this.redisMutexService.unlock("GLOBAL_ACTIVITY_STATUS_REDIS_LOCK");
                }
            }
        }
        Collection activitiesDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)details, ActivitiesDetailDto.class, ActivitiesDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(this.activitiesDetailEventListeners)) {
            this.activitiesDetailEventListeners.forEach(listener -> listener.onClosed(activitiesDetailVos));
        }
    }

    public int countByCostTypeCategoryCode(String costTypeCategoryCode) {
        return this.activitiesDetailRepository.countByCostTypeCategoryCode(costTypeCategoryCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateOrderAmountByActivitiesCode(String activitiesDetailCode, BigDecimal changeAmount, boolean isAdd) {
        String key = String.format("bz:crm:tpm:activities:order:lock:%s:%s", TenantUtils.getTenantCode(), activitiesDetailCode);
        boolean isLock = false;
        try {
            isLock = this.redisMutexService.tryLock(key, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)isLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            ActivitiesDetail activitiesDetail = this.activitiesDetailRepository.findByActivitiesDetailCode(activitiesDetailCode);
            BigDecimal orderedAmount = activitiesDetail.getTotalAmount();
            orderedAmount = isAdd ? orderedAmount.add(changeAmount) : orderedAmount.subtract(changeAmount);
            activitiesDetail.setTotalAmount(orderedAmount);
            this.activitiesDetailRepository.saveOrUpdate((Object)activitiesDetail);
        }
        finally {
            if (isLock) {
                this.redisMutexService.unlock(key);
            }
        }
    }

    @Transactional
    public void updateFullAuditByActivitiesDetailCode(String activitiesDetailCode, String isFullAudit) {
        ActivitiesDetail activitiesDetail = this.activitiesDetailRepository.findByActivitiesDetailCode(activitiesDetailCode);
        Validate.notNull((Object)((Object)activitiesDetail), (String)"\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff0c\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011", (Object[])new Object[]{activitiesDetailCode});
        activitiesDetail.setIsFullAudit(isFullAudit);
        this.activitiesDetailRepository.saveOrUpdate((Object)activitiesDetail);
    }

    private void createValidate(ActivitiesDetailDto activitiesDetailDto) {
        Validate.notNull((Object)activitiesDetailDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((activitiesDetailDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getActivitiesDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getCostTypeCategoryName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getCostTypeCategoryCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getCostBudgetCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getCostTypeDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getCostTypeDetailName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getBudgetSubjectsCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getBudgetSubjectsName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDetailDto.getApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDetailDto.getPayType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void fillDetail(ActivitiesDetailVo activitiesDetailVo) {
        ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(activitiesDetailVo.getActivitiesCode());
        activitiesDetailVo.setActivities(activitiesVo);
        List<ActivitiesDetailSerialVo> activitiesDetailSerialVos = this.activitiesDetailSerialService.findByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
        activitiesDetailVo.setActivitiesDetailSerials(activitiesDetailSerialVos);
        CostTypeCategoryVo costTypeCategoryVo = this.costTypeCategoryVoService.findByCode(activitiesDetailVo.getCostTypeCategoryCode());
        activitiesDetailVo.setActivitiesFormCode(costTypeCategoryVo.getFormCode());
        CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(activitiesDetailVo.getCostTypeDetailCode());
        activitiesDetailVo.setCostTypeDetailVo(costTypeDetailVo);
        String photoRequire = costTypeDetailVo.getPhotoRequire();
        if (StringUtils.isNotBlank((CharSequence)photoRequire)) {
            String[] photoRequires = StringUtils.split((String)photoRequire, (String)",");
            Set photoRequireSet = Arrays.stream(photoRequires).collect(Collectors.toSet());
            List approvalCollectVos = this.approvalCollectVoService.findDetailsByCodes(photoRequireSet);
            activitiesDetailVo.setPhotoRequires(approvalCollectVos);
        }
        List activitiesDetailCollectVos = this.activitiesDetailCollectService.findByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
        activitiesDetailVo.setActivitiesDetailCollects(activitiesDetailCollectVos);
        if (StringUtils.isNotBlank((CharSequence)costTypeDetailVo.getCollectRequire())) {
            List activitiesFieldsCollectTemplateVos;
            activitiesDetailVo.setFieldsCollectFormCode(costTypeDetailVo.getCollectRequire());
            JSONObject fieldsCollectTemplateStruct = this.dynamicTemplateService.findByDynamicFormCode(costTypeDetailVo.getCollectRequire());
            if (fieldsCollectTemplateStruct != null && fieldsCollectTemplateStruct.size() > 0) {
                fieldsCollectTemplateStruct.put("dynamicFormFieldCode", (Object)"items");
                activitiesDetailVo.setFieldsCollectTemplateStruct(fieldsCollectTemplateStruct);
            }
            if (!CollectionUtils.isEmpty((Collection)(activitiesFieldsCollectTemplateVos = this.activitiesFieldsCollectTemplateService.findByActivityDetailCode(activitiesDetailVo.getActivitiesDetailCode())))) {
                Collection fieldsCollectTemplateFeginVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)activitiesFieldsCollectTemplateVos, ActivitiesFieldsCollectTemplateVo.class, ActivitiesFieldsCollectTemplateFeginVo.class, HashSet.class, ArrayList.class, new String[0]);
                activitiesDetailVo.setFieldsCollectTemplates((List)Lists.newArrayList((Iterable)fieldsCollectTemplateFeginVos));
            }
        }
    }

    @Transactional
    public ActivitiesDetailVo createRemote(ActivitiesDetailRemoteDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdc\u7a0b\u4fdd\u5b58\u65f6\uff0c\u76f8\u5173\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBtNo(), (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActivitiesDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ActivitiesDetailVo activitiesDetail = this.findByActivitiesDetailCode(dto.getActivitiesDetailCode());
        Validate.notNull((Object)activitiesDetail, (String)"\u6839\u636e\u6307\u5b9a\u7684\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{dto.getActivitiesDetailCode()});
        CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(activitiesDetail.getCostTypeDetailCode());
        Validate.notNull((Object)costTypeDetailVo, (String)"\u4fdd\u5b58\u65f6\uff0c\u6570\u636e\u5173\u8054\u6d3b\u52a8\u660e\u7ec6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getCapital().equals(costTypeDetailVo.getIsCollectDistributionOrder()) || BooleanEnum.TRUE.getCapital().equals(costTypeDetailVo.getIsSignDisplayAgreement())) {
            Validate.notEmpty((Collection)dto.getActivitiesDetailSerials(), (String)"\u6d3b\u52a8\u8ba2\u5355\u6216\u534f\u8bae\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.getActivitiesDetailSerials().forEach(e -> e.setBtNo(dto.getBtNo()));
            List<ActivitiesDetailSerialVo> activitiesDetailSerials = this.activitiesDetailSerialService.createBatch(dto.getActivitiesDetailSerials());
            activitiesDetail.setActivitiesDetailSerials(activitiesDetailSerials);
        }
        if (BooleanEnum.TRUE.getCapital().equals(costTypeDetailVo.getIsCollectData())) {
            Validate.notEmpty((Collection)dto.getActivitiesDetailCollects(), (String)"\u6d3b\u52a8\u8ba2\u5355\u56fe\u7247\u91c7\u96c6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.getActivitiesDetailCollects().forEach(e -> e.setBtNo(dto.getBtNo()));
            List activitiesDetailCollects = this.activitiesDetailCollectService.createBatch((Collection)dto.getActivitiesDetailCollects());
            activitiesDetail.setActivitiesDetailCollects(activitiesDetailCollects);
        }
        if (dto.getFieldsCollectTemplate() != null && dto.getFieldsCollectTemplate().size() > 0) {
            dto.getFieldsCollectTemplate().put("btNo", (Object)dto.getBtNo());
            dto.getFieldsCollectTemplate().put("activityDetailCode", (Object)dto.getActivitiesDetailCode());
            ActivitiesFieldsCollectTemplateVo fieldsCollectTemplate = this.activitiesFieldsCollectTemplateService.create(dto.getFieldsCollectTemplate());
            ActivitiesFieldsCollectTemplateFeginVo fieldsCollectTemplateFeginVo = (ActivitiesFieldsCollectTemplateFeginVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)fieldsCollectTemplate, ActivitiesFieldsCollectTemplateFeginVo.class, HashSet.class, ArrayList.class, new String[0]);
            activitiesDetail.setFieldsCollectTemplates((List)Lists.newArrayList((Object[])new ActivitiesFieldsCollectTemplateFeginVo[]{fieldsCollectTemplateFeginVo}));
        }
        if (BooleanEnum.FALSE.getCapital().equals(activitiesDetail.getIsExecute())) {
            this.activitiesDetailRepository.updateIsExecutedByActivitiesDetailCode(activitiesDetail.getActivitiesDetailCode());
            activitiesDetail.setIsExecute(BooleanEnum.TRUE.getCapital());
        }
        return activitiesDetail;
    }

    public int countByActivitiesCodeAndClosed(String activitiesCode) {
        return this.activitiesDetailRepository.countByActivitiesCodeAndClosed(activitiesCode);
    }
}

